@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.GetTrackerAssociationPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTrackerAssociation.
 * @property consumerArn ARN of the geofence collection associated to tracker resource.
 * @property trackerName Name of the tracker resource associated with a geofence collection.
 */
public data class GetTrackerAssociationPlainArgs(
    public val consumerArn: String,
    public val trackerName: String,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.GetTrackerAssociationPlainArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.GetTrackerAssociationPlainArgs =
        com.pulumi.aws.location.inputs.GetTrackerAssociationPlainArgs.builder()
            .consumerArn(consumerArn.let({ args0 -> args0 }))
            .trackerName(trackerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrackerAssociationPlainArgs].
 */
@PulumiTagMarker
public class GetTrackerAssociationPlainArgsBuilder internal constructor() {
    private var consumerArn: String? = null

    private var trackerName: String? = null

    /**
     * @param value ARN of the geofence collection associated to tracker resource.
     */
    @JvmName("kmnnpnbmgqwkwpgm")
    public suspend fun consumerArn(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.consumerArn = mapped
    }

    /**
     * @param value Name of the tracker resource associated with a geofence collection.
     */
    @JvmName("qadvpimftxflgdmj")
    public suspend fun trackerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trackerName = mapped
    }

    internal fun build(): GetTrackerAssociationPlainArgs = GetTrackerAssociationPlainArgs(
        consumerArn = consumerArn ?: throw PulumiNullFieldException("consumerArn"),
        trackerName = trackerName ?: throw PulumiNullFieldException("trackerName"),
    )
}
