@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.GetTrackerPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getTracker.
 * @property tags Key-value map of resource tags for the tracker.
 * @property trackerName Name of the tracker resource.
 */
public data class GetTrackerPlainArgs(
    public val tags: Map<String, String>? = null,
    public val trackerName: String,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.GetTrackerPlainArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.GetTrackerPlainArgs =
        com.pulumi.aws.location.inputs.GetTrackerPlainArgs.builder()
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .trackerName(trackerName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetTrackerPlainArgs].
 */
@PulumiTagMarker
public class GetTrackerPlainArgsBuilder internal constructor() {
    private var tags: Map<String, String>? = null

    private var trackerName: String? = null

    /**
     * @param value Key-value map of resource tags for the tracker.
     */
    @JvmName("gvfbxjaejtaxilvr")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags for the tracker.
     */
    @JvmName("dxxlbxypwbswgrku")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value Name of the tracker resource.
     */
    @JvmName("refqyjimhnphmxrq")
    public suspend fun trackerName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.trackerName = mapped
    }

    internal fun build(): GetTrackerPlainArgs = GetTrackerPlainArgs(
        tags = tags,
        trackerName = trackerName ?: throw PulumiNullFieldException("trackerName"),
    )
}
