@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.inputs

import com.pulumi.aws.location.inputs.MapConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property style Specifies the map style selected from an available data provider. Valid values can be found in the [Location Service CreateMap API Reference](https://docs.aws.amazon.com/location/latest/APIReference/API_CreateMap.html).
 */
public data class MapConfigurationArgs(
    public val style: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.location.inputs.MapConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.location.inputs.MapConfigurationArgs =
        com.pulumi.aws.location.inputs.MapConfigurationArgs.builder()
            .style(style.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MapConfigurationArgs].
 */
@PulumiTagMarker
public class MapConfigurationArgsBuilder internal constructor() {
    private var style: Output<String>? = null

    /**
     * @param value Specifies the map style selected from an available data provider. Valid values can be found in the [Location Service CreateMap API Reference](https://docs.aws.amazon.com/location/latest/APIReference/API_CreateMap.html).
     */
    @JvmName("ekkmaeqjuhlmkatj")
    public suspend fun style(`value`: Output<String>) {
        this.style = value
    }

    /**
     * @param value Specifies the map style selected from an available data provider. Valid values can be found in the [Location Service CreateMap API Reference](https://docs.aws.amazon.com/location/latest/APIReference/API_CreateMap.html).
     */
    @JvmName("skbnlbyrdsnducfr")
    public suspend fun style(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.style = mapped
    }

    internal fun build(): MapConfigurationArgs = MapConfigurationArgs(
        style = style ?: throw PulumiNullFieldException("style"),
    )
}
