@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A collection of values returned by getTracker.
 * @property createTime Timestamp for when the tracker resource was created in ISO 8601 format.
 * @property description Optional description for the tracker resource.
 * @property id The provider-assigned unique ID for this managed resource.
 * @property kmsKeyId Key identifier for an AWS KMS customer managed key assigned to the Amazon Location resource.
 * @property positionFiltering Position filtering method of the tracker resource.
 * @property tags Key-value map of resource tags for the tracker.
 * @property trackerArn ARN for the tracker resource. Used when you need to specify a resource across all AWS.
 * @property trackerName
 * @property updateTime Timestamp for when the tracker resource was last updated in ISO 8601 format.
 */
public data class GetTrackerResult(
    public val createTime: String,
    public val description: String,
    public val id: String,
    public val kmsKeyId: String,
    public val positionFiltering: String,
    public val tags: Map<String, String>,
    public val trackerArn: String,
    public val trackerName: String,
    public val updateTime: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.GetTrackerResult):
            GetTrackerResult = GetTrackerResult(
            createTime = javaType.createTime(),
            description = javaType.description(),
            id = javaType.id(),
            kmsKeyId = javaType.kmsKeyId(),
            positionFiltering = javaType.positionFiltering(),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            trackerArn = javaType.trackerArn(),
            trackerName = javaType.trackerName(),
            updateTime = javaType.updateTime(),
        )
    }
}
