@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.location.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property style Specifies the map style selected from an available data provider. Valid values can be found in the [Location Service CreateMap API Reference](https://docs.aws.amazon.com/location/latest/APIReference/API_CreateMap.html).
 */
public data class MapConfiguration(
    public val style: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.location.outputs.MapConfiguration):
            MapConfiguration = MapConfiguration(
            style = javaType.style(),
        )
    }
}
