@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin

import com.pulumi.aws.macie.CustomDataIdentifierArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [AWS Macie Custom Data Identifier](https://docs.aws.amazon.com/macie/latest/APIReference/custom-data-identifiers-id.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie.CustomDataIdentifier;
 * import com.pulumi.aws.macie.CustomDataIdentifierArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleCustomDataIdentifier = new CustomDataIdentifier("exampleCustomDataIdentifier", CustomDataIdentifierArgs.builder()
 *             .regex("[0-9]{3}-[0-9]{2}-[0-9]{4}")
 *             .description("DESCRIPTION")
 *             .maximumMatchDistance(10)
 *             .keywords("keyword")
 *             .ignoreWords("ignore")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_macie2_account.test())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_custom_data_identifier` using the id. For example:
 * ```sh
 *  $ pulumi import aws:macie/customDataIdentifier:CustomDataIdentifier example abcd1
 * ```
 * @property description A custom description of the custom data identifier. The description can contain as many as 512 characters.
 * @property ignoreWords An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
 * @property keywords An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
 * @property maximumMatchDistance The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
 * @property name A custom name for the custom data identifier. The name can contain as many as 128 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property regex The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
 * @property tags A map of key-value pairs that specifies the tags to associate with the custom data identifier.
 */
public data class CustomDataIdentifierArgs(
    public val description: Output<String>? = null,
    public val ignoreWords: Output<List<String>>? = null,
    public val keywords: Output<List<String>>? = null,
    public val maximumMatchDistance: Output<Int>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val regex: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie.CustomDataIdentifierArgs> {
    override fun toJava(): com.pulumi.aws.macie.CustomDataIdentifierArgs =
        com.pulumi.aws.macie.CustomDataIdentifierArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .ignoreWords(ignoreWords?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .keywords(keywords?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .maximumMatchDistance(maximumMatchDistance?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .regex(regex?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [CustomDataIdentifierArgs].
 */
@PulumiTagMarker
public class CustomDataIdentifierArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var ignoreWords: Output<List<String>>? = null

    private var keywords: Output<List<String>>? = null

    private var maximumMatchDistance: Output<Int>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var regex: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value A custom description of the custom data identifier. The description can contain as many as 512 characters.
     */
    @JvmName("ifsixvrimgmerwmy")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("xhpiwndslmtwohfb")
    public suspend fun ignoreWords(`value`: Output<List<String>>) {
        this.ignoreWords = value
    }

    @JvmName("topwgmcvvupkjnjp")
    public suspend fun ignoreWords(vararg values: Output<String>) {
        this.ignoreWords = Output.all(values.asList())
    }

    /**
     * @param values An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("mphvgfuflmcygdse")
    public suspend fun ignoreWords(values: List<Output<String>>) {
        this.ignoreWords = Output.all(values)
    }

    /**
     * @param value An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("gqgkedwnmlkmpijt")
    public suspend fun keywords(`value`: Output<List<String>>) {
        this.keywords = value
    }

    @JvmName("yatnxehucvwofaay")
    public suspend fun keywords(vararg values: Output<String>) {
        this.keywords = Output.all(values.asList())
    }

    /**
     * @param values An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("nhiwhihouwdjdgfi")
    public suspend fun keywords(values: List<Output<String>>) {
        this.keywords = Output.all(values)
    }

    /**
     * @param value The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
     */
    @JvmName("oaywbeboopowraua")
    public suspend fun maximumMatchDistance(`value`: Output<Int>) {
        this.maximumMatchDistance = value
    }

    /**
     * @param value A custom name for the custom data identifier. The name can contain as many as 128 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("qqrtyyarwoxcdbom")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("ahkpfgeihpqhnorx")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
     */
    @JvmName("yuaslkymvdtodxxg")
    public suspend fun regex(`value`: Output<String>) {
        this.regex = value
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     */
    @JvmName("jcafjjhkshoihyij")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value A custom description of the custom data identifier. The description can contain as many as 512 characters.
     */
    @JvmName("npxpalxlolwtemxl")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("qnhvxdrhlftxmhbh")
    public suspend fun ignoreWords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ignoreWords = mapped
    }

    /**
     * @param values An array that lists specific character sequences (ignore words) to exclude from the results. If the text matched by the regular expression is the same as any string in this array, Amazon Macie ignores it. The array can contain as many as 10 ignore words. Each ignore word can contain 4 - 90 characters. Ignore words are case sensitive.
     */
    @JvmName("tagujioqhouqhefl")
    public suspend fun ignoreWords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ignoreWords = mapped
    }

    /**
     * @param value An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("btmpiadrilhdwwsh")
    public suspend fun keywords(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param values An array that lists specific character sequences (keywords), one of which must be within proximity (`maximum_match_distance`) of the regular expression to match. The array can contain as many as 50 keywords. Each keyword can contain 3 - 90 characters. Keywords aren't case sensitive.
     */
    @JvmName("usxdvcrxcuqxlpsi")
    public suspend fun keywords(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keywords = mapped
    }

    /**
     * @param value The maximum number of characters that can exist between text that matches the regex pattern and the character sequences specified by the keywords array. Macie includes or excludes a result based on the proximity of a keyword to text that matches the regex pattern. The distance can be 1 - 300 characters. The default value is 50.
     */
    @JvmName("ssvvxwhjksphdmlr")
    public suspend fun maximumMatchDistance(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maximumMatchDistance = mapped
    }

    /**
     * @param value A custom name for the custom data identifier. The name can contain as many as 128 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("tkmuaglswvaljdfn")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("klgyqmglqwyucmjn")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The regular expression (regex) that defines the pattern to match. The expression can contain as many as 512 characters.
     */
    @JvmName("cadqfaeigtbymeve")
    public suspend fun regex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.regex = mapped
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     */
    @JvmName("kqsfcdoiycgwfgbn")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of key-value pairs that specifies the tags to associate with the custom data identifier.
     */
    @JvmName("ykfboekcipasdlyc")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): CustomDataIdentifierArgs = CustomDataIdentifierArgs(
        description = description,
        ignoreWords = ignoreWords,
        keywords = keywords,
        maximumMatchDistance = maximumMatchDistance,
        name = name,
        namePrefix = namePrefix,
        regex = regex,
        tags = tags,
    )
}
