@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin

import com.pulumi.aws.macie.kotlin.outputs.FindingsFilterFindingCriteria
import com.pulumi.aws.macie.kotlin.outputs.FindingsFilterFindingCriteria.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [FindingsFilter].
 */
@PulumiTagMarker
public class FindingsFilterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: FindingsFilterArgs = FindingsFilterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend FindingsFilterArgsBuilder.() -> Unit) {
        val builder = FindingsFilterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): FindingsFilter {
        val builtJavaResource = com.pulumi.aws.macie.FindingsFilter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return FindingsFilter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Findings Filter](https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie.FindingsFilter;
 * import com.pulumi.aws.macie.FindingsFilterArgs;
 * import com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var test = new FindingsFilter("test", FindingsFilterArgs.builder()
 *             .description("DESCRIPTION")
 *             .position(1)
 *             .action("ARCHIVE")
 *             .findingCriteria(FindingsFilterFindingCriteriaArgs.builder()
 *                 .criterions(FindingsFilterFindingCriteriaCriterionArgs.builder()
 *                     .field("region")
 *                     .eqs(data.aws_region().current().name())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_macie2_account.test())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_findings_filter` using the id. For example:
 * ```sh
 *  $ pulumi import aws:macie/findingsFilter:FindingsFilter example abcd1
 * ```
 *
 */
public class FindingsFilter internal constructor(
    override val javaResource: com.pulumi.aws.macie.FindingsFilter,
) : KotlinCustomResource(javaResource, FindingsFilterMapper) {
    /**
     * The action to perform on findings that meet the filter criteria (`finding_criteria`). Valid values are: `ARCHIVE`, suppress (automatically archive) the findings; and, `NOOP`, don't perform any action on the findings.
     */
    public val action: Output<String>
        get() = javaResource.action().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the Findings Filter.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A custom description of the filter. The description can contain as many as 512 characters.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * The criteria to use to filter findings.
     */
    public val findingCriteria: Output<FindingsFilterFindingCriteria>
        get() = javaResource.findingCriteria().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    public val namePrefix: Output<String>
        get() = javaResource.namePrefix().applyValue({ args0 -> args0 })

    /**
     * The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    public val position: Output<Int>
        get() = javaResource.position().applyValue({ args0 -> args0 })

    /**
     * A map of key-value pairs that specifies the tags to associate with the filter.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object FindingsFilterMapper : ResourceMapper<FindingsFilter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie.FindingsFilter::class == javaResource::class

    override fun map(javaResource: Resource): FindingsFilter = FindingsFilter(
        javaResource as
            com.pulumi.aws.macie.FindingsFilter,
    )
}

/**
 * @see [FindingsFilter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [FindingsFilter].
 */
public suspend fun findingsFilter(
    name: String,
    block: suspend FindingsFilterResourceBuilder.() -> Unit,
): FindingsFilter {
    val builder = FindingsFilterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [FindingsFilter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun findingsFilter(name: String): FindingsFilter {
    val builder = FindingsFilterResourceBuilder()
    builder.name(name)
    return builder.build()
}
