@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin

import com.pulumi.aws.macie.FindingsFilterArgs.builder
import com.pulumi.aws.macie.kotlin.inputs.FindingsFilterFindingCriteriaArgs
import com.pulumi.aws.macie.kotlin.inputs.FindingsFilterFindingCriteriaArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Macie Findings Filter](https://docs.aws.amazon.com/macie/latest/APIReference/findingsfilters-id.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie.FindingsFilter;
 * import com.pulumi.aws.macie.FindingsFilterArgs;
 * import com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Account("example");
 *         var test = new FindingsFilter("test", FindingsFilterArgs.builder()
 *             .description("DESCRIPTION")
 *             .position(1)
 *             .action("ARCHIVE")
 *             .findingCriteria(FindingsFilterFindingCriteriaArgs.builder()
 *                 .criterions(FindingsFilterFindingCriteriaCriterionArgs.builder()
 *                     .field("region")
 *                     .eqs(data.aws_region().current().name())
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(aws_macie2_account.test())
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_findings_filter` using the id. For example:
 * ```sh
 *  $ pulumi import aws:macie/findingsFilter:FindingsFilter example abcd1
 * ```
 * @property action The action to perform on findings that meet the filter criteria (`finding_criteria`). Valid values are: `ARCHIVE`, suppress (automatically archive) the findings; and, `NOOP`, don't perform any action on the findings.
 * @property description A custom description of the filter. The description can contain as many as 512 characters.
 * @property findingCriteria The criteria to use to filter findings.
 * @property name A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property position The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
 * @property tags A map of key-value pairs that specifies the tags to associate with the filter.
 */
public data class FindingsFilterArgs(
    public val action: Output<String>? = null,
    public val description: Output<String>? = null,
    public val findingCriteria: Output<FindingsFilterFindingCriteriaArgs>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val position: Output<Int>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie.FindingsFilterArgs> {
    override fun toJava(): com.pulumi.aws.macie.FindingsFilterArgs =
        com.pulumi.aws.macie.FindingsFilterArgs.builder()
            .action(action?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .findingCriteria(findingCriteria?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .position(position?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FindingsFilterArgs].
 */
@PulumiTagMarker
public class FindingsFilterArgsBuilder internal constructor() {
    private var action: Output<String>? = null

    private var description: Output<String>? = null

    private var findingCriteria: Output<FindingsFilterFindingCriteriaArgs>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var position: Output<Int>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The action to perform on findings that meet the filter criteria (`finding_criteria`). Valid values are: `ARCHIVE`, suppress (automatically archive) the findings; and, `NOOP`, don't perform any action on the findings.
     */
    @JvmName("cpcuqxabcyhowmre")
    public suspend fun action(`value`: Output<String>) {
        this.action = value
    }

    /**
     * @param value A custom description of the filter. The description can contain as many as 512 characters.
     */
    @JvmName("jqmxpbquxgvmrwcc")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The criteria to use to filter findings.
     */
    @JvmName("khaywquqxahwwddl")
    public suspend fun findingCriteria(`value`: Output<FindingsFilterFindingCriteriaArgs>) {
        this.findingCriteria = value
    }

    /**
     * @param value A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("xxsqcvoxvblywmdb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("wofifhyfodarbtdv")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    @JvmName("ponjbwqbplrdiech")
    public suspend fun position(`value`: Output<Int>) {
        this.position = value
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the filter.
     */
    @JvmName("wvrgcnjidwmnhqsd")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The action to perform on findings that meet the filter criteria (`finding_criteria`). Valid values are: `ARCHIVE`, suppress (automatically archive) the findings; and, `NOOP`, don't perform any action on the findings.
     */
    @JvmName("ysfrvchsskvjpvdl")
    public suspend fun action(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.action = mapped
    }

    /**
     * @param value A custom description of the filter. The description can contain as many as 512 characters.
     */
    @JvmName("pucctmdpcbarrmwm")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The criteria to use to filter findings.
     */
    @JvmName("jttlotqbhkvscdsu")
    public suspend fun findingCriteria(`value`: FindingsFilterFindingCriteriaArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.findingCriteria = mapped
    }

    /**
     * @param argument The criteria to use to filter findings.
     */
    @JvmName("jrqwmlmvjaeapirc")
    public suspend
    fun findingCriteria(argument: suspend FindingsFilterFindingCriteriaArgsBuilder.() -> Unit) {
        val toBeMapped = FindingsFilterFindingCriteriaArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.findingCriteria = mapped
    }

    /**
     * @param value A custom name for the filter. The name must contain at least 3 characters and can contain as many as 64 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("swuyicnctntqbwnr")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("isuqsqicdciciglc")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The position of the filter in the list of saved filters on the Amazon Macie console. This value also determines the order in which the filter is applied to findings, relative to other filters that are also applied to the findings.
     */
    @JvmName("mhswlvctbyrimuhk")
    public suspend fun position(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.position = mapped
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the filter.
     */
    @JvmName("kdpcebsyxhxdmgcy")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of key-value pairs that specifies the tags to associate with the filter.
     */
    @JvmName("ggdnrdjmimttfhbi")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): FindingsFilterArgs = FindingsFilterArgs(
        action = action,
        description = description,
        findingCriteria = findingCriteria,
        name = name,
        namePrefix = namePrefix,
        position = position,
        tags = tags,
    )
}
