@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin.inputs

import com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaCriterionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property eqExactMatches The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
 * @property eqs The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
 * @property field The name of the field to be evaluated.
 * @property gt The value for the property is greater than the specified value.
 * @property gte The value for the property is greater than or equal to the specified value.
 * @property lt The value for the property is less than the specified value.
 * @property lte The value for the property is less than or equal to the specified value.
 * @property neqs The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
 */
public data class FindingsFilterFindingCriteriaCriterionArgs(
    public val eqExactMatches: Output<List<String>>? = null,
    public val eqs: Output<List<String>>? = null,
    public val `field`: Output<String>,
    public val gt: Output<String>? = null,
    public val gte: Output<String>? = null,
    public val lt: Output<String>? = null,
    public val lte: Output<String>? = null,
    public val neqs: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaCriterionArgs> {
    override fun toJava(): com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaCriterionArgs =
        com.pulumi.aws.macie.inputs.FindingsFilterFindingCriteriaCriterionArgs.builder()
            .eqExactMatches(eqExactMatches?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .eqs(eqs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .`field`(`field`.applyValue({ args0 -> args0 }))
            .gt(gt?.applyValue({ args0 -> args0 }))
            .gte(gte?.applyValue({ args0 -> args0 }))
            .lt(lt?.applyValue({ args0 -> args0 }))
            .lte(lte?.applyValue({ args0 -> args0 }))
            .neqs(neqs?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FindingsFilterFindingCriteriaCriterionArgs].
 */
@PulumiTagMarker
public class FindingsFilterFindingCriteriaCriterionArgsBuilder internal constructor() {
    private var eqExactMatches: Output<List<String>>? = null

    private var eqs: Output<List<String>>? = null

    private var `field`: Output<String>? = null

    private var gt: Output<String>? = null

    private var gte: Output<String>? = null

    private var lt: Output<String>? = null

    private var lte: Output<String>? = null

    private var neqs: Output<List<String>>? = null

    /**
     * @param value The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
     */
    @JvmName("opoeogxwftjxmnem")
    public suspend fun eqExactMatches(`value`: Output<List<String>>) {
        this.eqExactMatches = value
    }

    @JvmName("pvkkmicmayqpvyju")
    public suspend fun eqExactMatches(vararg values: Output<String>) {
        this.eqExactMatches = Output.all(values.asList())
    }

    /**
     * @param values The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
     */
    @JvmName("ebkaxclccoiwxbro")
    public suspend fun eqExactMatches(values: List<Output<String>>) {
        this.eqExactMatches = Output.all(values)
    }

    /**
     * @param value The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("tqejwrwawpktehcp")
    public suspend fun eqs(`value`: Output<List<String>>) {
        this.eqs = value
    }

    @JvmName("citufeqqoiqymvfg")
    public suspend fun eqs(vararg values: Output<String>) {
        this.eqs = Output.all(values.asList())
    }

    /**
     * @param values The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("sbglnvvcwgljqiia")
    public suspend fun eqs(values: List<Output<String>>) {
        this.eqs = Output.all(values)
    }

    /**
     * @param value The name of the field to be evaluated.
     */
    @JvmName("gnaxxhuxmtuwylrf")
    public suspend fun `field`(`value`: Output<String>) {
        this.`field` = value
    }

    /**
     * @param value The value for the property is greater than the specified value.
     */
    @JvmName("uigwirrohuamfvbu")
    public suspend fun gt(`value`: Output<String>) {
        this.gt = value
    }

    /**
     * @param value The value for the property is greater than or equal to the specified value.
     */
    @JvmName("llngdtabjjbwswhc")
    public suspend fun gte(`value`: Output<String>) {
        this.gte = value
    }

    /**
     * @param value The value for the property is less than the specified value.
     */
    @JvmName("wxmyobjvrknqrjjv")
    public suspend fun lt(`value`: Output<String>) {
        this.lt = value
    }

    /**
     * @param value The value for the property is less than or equal to the specified value.
     */
    @JvmName("hpsmpgbuuyfaittm")
    public suspend fun lte(`value`: Output<String>) {
        this.lte = value
    }

    /**
     * @param value The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("ygywhohoomecmfqg")
    public suspend fun neqs(`value`: Output<List<String>>) {
        this.neqs = value
    }

    @JvmName("jfqjmyustehygrmn")
    public suspend fun neqs(vararg values: Output<String>) {
        this.neqs = Output.all(values.asList())
    }

    /**
     * @param values The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("ocbsewlxanladfdu")
    public suspend fun neqs(values: List<Output<String>>) {
        this.neqs = Output.all(values)
    }

    /**
     * @param value The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
     */
    @JvmName("jfduwknftooxinar")
    public suspend fun eqExactMatches(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eqExactMatches = mapped
    }

    /**
     * @param values The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
     */
    @JvmName("oveeamjnusddoxdl")
    public suspend fun eqExactMatches(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eqExactMatches = mapped
    }

    /**
     * @param value The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("qxwfqvnfylxnktty")
    public suspend fun eqs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eqs = mapped
    }

    /**
     * @param values The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("oisiiryujrawhmwv")
    public suspend fun eqs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.eqs = mapped
    }

    /**
     * @param value The name of the field to be evaluated.
     */
    @JvmName("jvceesywanqtjfgd")
    public suspend fun `field`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`field` = mapped
    }

    /**
     * @param value The value for the property is greater than the specified value.
     */
    @JvmName("bojkustvpixvonmq")
    public suspend fun gt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gt = mapped
    }

    /**
     * @param value The value for the property is greater than or equal to the specified value.
     */
    @JvmName("bkqccdoljxpeotdw")
    public suspend fun gte(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.gte = mapped
    }

    /**
     * @param value The value for the property is less than the specified value.
     */
    @JvmName("nsauowghlhtlugap")
    public suspend fun lt(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lt = mapped
    }

    /**
     * @param value The value for the property is less than or equal to the specified value.
     */
    @JvmName("bkaxbqcwleansdcm")
    public suspend fun lte(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lte = mapped
    }

    /**
     * @param value The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("qeurdnyfjijdoliu")
    public suspend fun neqs(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.neqs = mapped
    }

    /**
     * @param values The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
     */
    @JvmName("yunbaqllvrrggref")
    public suspend fun neqs(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.neqs = mapped
    }

    internal fun build(): FindingsFilterFindingCriteriaCriterionArgs =
        FindingsFilterFindingCriteriaCriterionArgs(
            eqExactMatches = eqExactMatches,
            eqs = eqs,
            `field` = `field` ?: throw PulumiNullFieldException("field"),
            gt = gt,
            gte = gte,
            lt = lt,
            lte = lte,
            neqs = neqs,
        )
}
