@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property eqExactMatches The value for the property exclusively matches (equals an exact match for) all the specified values. If you specify multiple values, Amazon Macie uses AND logic to join the values.
 * @property eqs The value for the property matches (equals) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
 * @property field The name of the field to be evaluated.
 * @property gt The value for the property is greater than the specified value.
 * @property gte The value for the property is greater than or equal to the specified value.
 * @property lt The value for the property is less than the specified value.
 * @property lte The value for the property is less than or equal to the specified value.
 * @property neqs The value for the property doesn't match (doesn't equal) the specified value. If you specify multiple values, Amazon Macie uses OR logic to join the values.
 */
public data class FindingsFilterFindingCriteriaCriterion(
    public val eqExactMatches: List<String>? = null,
    public val eqs: List<String>? = null,
    public val `field`: String,
    public val gt: String? = null,
    public val gte: String? = null,
    public val lt: String? = null,
    public val lte: String? = null,
    public val neqs: List<String>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.macie.outputs.FindingsFilterFindingCriteriaCriterion):
            FindingsFilterFindingCriteriaCriterion = FindingsFilterFindingCriteriaCriterion(
            eqExactMatches = javaType.eqExactMatches().map({ args0 -> args0 }),
            eqs = javaType.eqs().map({ args0 -> args0 }),
            `field` = javaType.`field`(),
            gt = javaType.gt().map({ args0 -> args0 }).orElse(null),
            gte = javaType.gte().map({ args0 -> args0 }).orElse(null),
            lt = javaType.lt().map({ args0 -> args0 }).orElse(null),
            lte = javaType.lte().map({ args0 -> args0 }).orElse(null),
            neqs = javaType.neqs().map({ args0 -> args0 }),
        )
    }
}
