@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.kotlin.outputs.ClassificationExportConfigurationS3Destination
import com.pulumi.aws.macie2.kotlin.outputs.ClassificationExportConfigurationS3Destination.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [ClassificationExportConfiguration].
 */
@PulumiTagMarker
public class ClassificationExportConfigurationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClassificationExportConfigurationArgs = ClassificationExportConfigurationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClassificationExportConfigurationArgsBuilder.() -> Unit) {
        val builder = ClassificationExportConfigurationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): ClassificationExportConfiguration {
        val builtJavaResource =
            com.pulumi.aws.macie2.ClassificationExportConfiguration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return ClassificationExportConfiguration(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Classification Export Configuration](https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationExportConfiguration;
 * import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleClassificationExportConfiguration = new ClassificationExportConfiguration("exampleClassificationExportConfiguration", ClassificationExportConfigurationArgs.builder()
 *             .s3Destination(ClassificationExportConfigurationS3DestinationArgs.builder()
 *                 .bucketName(aws_s3_bucket.example().bucket())
 *                 .keyPrefix("exampleprefix/")
 *                 .kmsKeyArn(aws_kms_key.example().arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_classification_export_configuration` using the account ID and region. For example:
 * ```sh
 *  $ pulumi import aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration example 123456789012:us-west-2
 * ```
 *
 */
public class ClassificationExportConfiguration internal constructor(
    override val javaResource: com.pulumi.aws.macie2.ClassificationExportConfiguration,
) : KotlinCustomResource(javaResource, ClassificationExportConfigurationMapper) {
    /**
     * Configuration block for a S3 Destination. Defined below
     */
    public val s3Destination: Output<ClassificationExportConfigurationS3Destination>?
        get() = javaResource.s3Destination().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })
}

public object ClassificationExportConfigurationMapper :
    ResourceMapper<ClassificationExportConfiguration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.ClassificationExportConfiguration::class == javaResource::class

    override fun map(javaResource: Resource): ClassificationExportConfiguration =
        ClassificationExportConfiguration(
            javaResource as
                com.pulumi.aws.macie2.ClassificationExportConfiguration,
        )
}

/**
 * @see [ClassificationExportConfiguration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ClassificationExportConfiguration].
 */
public suspend fun classificationExportConfiguration(
    name: String,
    block: suspend ClassificationExportConfigurationResourceBuilder.() -> Unit,
):
    ClassificationExportConfiguration {
    val builder = ClassificationExportConfigurationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ClassificationExportConfiguration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun classificationExportConfiguration(name: String): ClassificationExportConfiguration {
    val builder = ClassificationExportConfigurationResourceBuilder()
    builder.name(name)
    return builder.build()
}
