@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs.builder
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationExportConfigurationS3DestinationArgs
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationExportConfigurationS3DestinationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Macie Classification Export Configuration](https://docs.aws.amazon.com/macie/latest/APIReference/classification-export-configuration.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationExportConfiguration;
 * import com.pulumi.aws.macie2.ClassificationExportConfigurationArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationExportConfigurationS3DestinationArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleClassificationExportConfiguration = new ClassificationExportConfiguration("exampleClassificationExportConfiguration", ClassificationExportConfigurationArgs.builder()
 *             .s3Destination(ClassificationExportConfigurationS3DestinationArgs.builder()
 *                 .bucketName(aws_s3_bucket.example().bucket())
 *                 .keyPrefix("exampleprefix/")
 *                 .kmsKeyArn(aws_kms_key.example().arn())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_classification_export_configuration` using the account ID and region. For example:
 * ```sh
 *  $ pulumi import aws:macie2/classificationExportConfiguration:ClassificationExportConfiguration example 123456789012:us-west-2
 * ```
 * @property s3Destination Configuration block for a S3 Destination. Defined below
 */
public data class ClassificationExportConfigurationArgs(
    public val s3Destination: Output<ClassificationExportConfigurationS3DestinationArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.ClassificationExportConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.macie2.ClassificationExportConfigurationArgs =
        com.pulumi.aws.macie2.ClassificationExportConfigurationArgs.builder()
            .s3Destination(s3Destination?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationExportConfigurationArgs].
 */
@PulumiTagMarker
public class ClassificationExportConfigurationArgsBuilder internal constructor() {
    private var s3Destination: Output<ClassificationExportConfigurationS3DestinationArgs>? = null

    /**
     * @param value Configuration block for a S3 Destination. Defined below
     */
    @JvmName("kwjdtdutuqeycmhr")
    public suspend
    fun s3Destination(`value`: Output<ClassificationExportConfigurationS3DestinationArgs>) {
        this.s3Destination = value
    }

    /**
     * @param value Configuration block for a S3 Destination. Defined below
     */
    @JvmName("vuuwhowcelahsdrm")
    public suspend fun s3Destination(`value`: ClassificationExportConfigurationS3DestinationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3Destination = mapped
    }

    /**
     * @param argument Configuration block for a S3 Destination. Defined below
     */
    @JvmName("lmbpopxdjabbxpil")
    public suspend
    fun s3Destination(argument: suspend ClassificationExportConfigurationS3DestinationArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationExportConfigurationS3DestinationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3Destination = mapped
    }

    internal fun build(): ClassificationExportConfigurationArgs =
        ClassificationExportConfigurationArgs(
            s3Destination = s3Destination,
        )
}
