@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.ClassificationJobArgs.builder
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationJobS3JobDefinitionArgs
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationJobS3JobDefinitionArgsBuilder
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationJobScheduleFrequencyArgs
import com.pulumi.aws.macie2.kotlin.inputs.ClassificationJobScheduleFrequencyArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Int
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [AWS Macie Classification Job](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.ClassificationJob;
 * import com.pulumi.aws.macie2.ClassificationJobArgs;
 * import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testAccount = new Account("testAccount");
 *         var testClassificationJob = new ClassificationJob("testClassificationJob", ClassificationJobArgs.builder()
 *             .jobType("ONE_TIME")
 *             .s3JobDefinition(ClassificationJobS3JobDefinitionArgs.builder()
 *                 .bucketDefinitions(ClassificationJobS3JobDefinitionBucketDefinitionArgs.builder()
 *                     .accountId("ACCOUNT ID")
 *                     .buckets("S3 BUCKET NAME")
 *                     .build())
 *                 .build())
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(testAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_classification_job` using the id. For example:
 * ```sh
 *  $ pulumi import aws:macie2/classificationJob:ClassificationJob example abcd1
 * ```
 * @property customDataIdentifierIds The custom data identifiers to use for data analysis and classification.
 * @property description A custom description of the job. The description can contain as many as 200 characters.
 * @property initialRun Specifies whether to analyze all existing, eligible objects immediately after the job is created.
 * @property jobStatus The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
 * @property jobType The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
 * @property name A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
 * @property namePrefix Creates a unique name beginning with the specified prefix. Conflicts with `name`.
 * @property s3JobDefinition The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
 * @property samplingPercentage The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
 * @property scheduleFrequency The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
 * @property tags A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
 */
public data class ClassificationJobArgs(
    public val customDataIdentifierIds: Output<List<String>>? = null,
    public val description: Output<String>? = null,
    public val initialRun: Output<Boolean>? = null,
    public val jobStatus: Output<String>? = null,
    public val jobType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val namePrefix: Output<String>? = null,
    public val s3JobDefinition: Output<ClassificationJobS3JobDefinitionArgs>? = null,
    public val samplingPercentage: Output<Int>? = null,
    public val scheduleFrequency: Output<ClassificationJobScheduleFrequencyArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.ClassificationJobArgs> {
    override fun toJava(): com.pulumi.aws.macie2.ClassificationJobArgs =
        com.pulumi.aws.macie2.ClassificationJobArgs.builder()
            .customDataIdentifierIds(
                customDataIdentifierIds?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .initialRun(initialRun?.applyValue({ args0 -> args0 }))
            .jobStatus(jobStatus?.applyValue({ args0 -> args0 }))
            .jobType(jobType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .namePrefix(namePrefix?.applyValue({ args0 -> args0 }))
            .s3JobDefinition(s3JobDefinition?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .samplingPercentage(samplingPercentage?.applyValue({ args0 -> args0 }))
            .scheduleFrequency(scheduleFrequency?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ClassificationJobArgs].
 */
@PulumiTagMarker
public class ClassificationJobArgsBuilder internal constructor() {
    private var customDataIdentifierIds: Output<List<String>>? = null

    private var description: Output<String>? = null

    private var initialRun: Output<Boolean>? = null

    private var jobStatus: Output<String>? = null

    private var jobType: Output<String>? = null

    private var name: Output<String>? = null

    private var namePrefix: Output<String>? = null

    private var s3JobDefinition: Output<ClassificationJobS3JobDefinitionArgs>? = null

    private var samplingPercentage: Output<Int>? = null

    private var scheduleFrequency: Output<ClassificationJobScheduleFrequencyArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The custom data identifiers to use for data analysis and classification.
     */
    @JvmName("tmujgdleabxpftdo")
    public suspend fun customDataIdentifierIds(`value`: Output<List<String>>) {
        this.customDataIdentifierIds = value
    }

    @JvmName("errejrweywqwldou")
    public suspend fun customDataIdentifierIds(vararg values: Output<String>) {
        this.customDataIdentifierIds = Output.all(values.asList())
    }

    /**
     * @param values The custom data identifiers to use for data analysis and classification.
     */
    @JvmName("ycqrtbbgbnsxhvod")
    public suspend fun customDataIdentifierIds(values: List<Output<String>>) {
        this.customDataIdentifierIds = Output.all(values)
    }

    /**
     * @param value A custom description of the job. The description can contain as many as 200 characters.
     */
    @JvmName("ejwxgxvgfjhrctck")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     */
    @JvmName("gtfttwqbadncheuk")
    public suspend fun initialRun(`value`: Output<Boolean>) {
        this.initialRun = value
    }

    /**
     * @param value The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
     */
    @JvmName("lydjrgytceledtwx")
    public suspend fun jobStatus(`value`: Output<String>) {
        this.jobStatus = value
    }

    /**
     * @param value The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
     */
    @JvmName("uoccinwbcjxoehhm")
    public suspend fun jobType(`value`: Output<String>) {
        this.jobType = value
    }

    /**
     * @param value A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("amfvebuwmrktsqyc")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("pmqxddrmqprlhuei")
    public suspend fun namePrefix(`value`: Output<String>) {
        this.namePrefix = value
    }

    /**
     * @param value The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
     */
    @JvmName("nodykoyjeceqxwuq")
    public suspend fun s3JobDefinition(`value`: Output<ClassificationJobS3JobDefinitionArgs>) {
        this.s3JobDefinition = value
    }

    /**
     * @param value The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     */
    @JvmName("legkvobawncqrufw")
    public suspend fun samplingPercentage(`value`: Output<Int>) {
        this.samplingPercentage = value
    }

    /**
     * @param value The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
     */
    @JvmName("jebumiyquaounpub")
    public suspend fun scheduleFrequency(`value`: Output<ClassificationJobScheduleFrequencyArgs>) {
        this.scheduleFrequency = value
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    @JvmName("qqjwbbsdiqtbgdpo")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The custom data identifiers to use for data analysis and classification.
     */
    @JvmName("penoiexccfgpaqhb")
    public suspend fun customDataIdentifierIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customDataIdentifierIds = mapped
    }

    /**
     * @param values The custom data identifiers to use for data analysis and classification.
     */
    @JvmName("umfvqtkentgcqjod")
    public suspend fun customDataIdentifierIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.customDataIdentifierIds = mapped
    }

    /**
     * @param value A custom description of the job. The description can contain as many as 200 characters.
     */
    @JvmName("nkoogghqylxyuuxc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether to analyze all existing, eligible objects immediately after the job is created.
     */
    @JvmName("qwiltjsgfnuqewet")
    public suspend fun initialRun(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.initialRun = mapped
    }

    /**
     * @param value The status for the job. Valid values are: `CANCELLED`, `RUNNING` and `USER_PAUSED`
     */
    @JvmName("fnmeeppdwhtaomcy")
    public suspend fun jobStatus(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobStatus = mapped
    }

    /**
     * @param value The schedule for running the job. Valid values are: `ONE_TIME` - Run the job only once. If you specify this value, don't specify a value for the `schedule_frequency` property. `SCHEDULED` - Run the job on a daily, weekly, or monthly basis. If you specify this value, use the `schedule_frequency` property to define the recurrence pattern for the job.
     */
    @JvmName("ruilhnrvgxtiyylu")
    public suspend fun jobType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jobType = mapped
    }

    /**
     * @param value A custom name for the job. The name can contain as many as 500 characters. If omitted, the provider will assign a random, unique name. Conflicts with `name_prefix`.
     */
    @JvmName("uexliialxlqmsyph")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Creates a unique name beginning with the specified prefix. Conflicts with `name`.
     */
    @JvmName("xlwjfdmfctqvylqf")
    public suspend fun namePrefix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.namePrefix = mapped
    }

    /**
     * @param value The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
     */
    @JvmName("ttogaqqdboyntvuw")
    public suspend fun s3JobDefinition(`value`: ClassificationJobS3JobDefinitionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.s3JobDefinition = mapped
    }

    /**
     * @param argument The S3 buckets that contain the objects to analyze, and the scope of that analysis. (documented below)
     */
    @JvmName("jjrrwshulodjwreb")
    public suspend
    fun s3JobDefinition(argument: suspend ClassificationJobS3JobDefinitionArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationJobS3JobDefinitionArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.s3JobDefinition = mapped
    }

    /**
     * @param value The sampling depth, as a percentage, to apply when processing objects. This value determines the percentage of eligible objects that the job analyzes. If this value is less than 100, Amazon Macie selects the objects to analyze at random, up to the specified percentage, and analyzes all the data in those objects.
     */
    @JvmName("niunuehkoxyngeyh")
    public suspend fun samplingPercentage(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.samplingPercentage = mapped
    }

    /**
     * @param value The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
     */
    @JvmName("knwvirrldovmwfgo")
    public suspend fun scheduleFrequency(`value`: ClassificationJobScheduleFrequencyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scheduleFrequency = mapped
    }

    /**
     * @param argument The recurrence pattern for running the job. To run the job only once, don't specify a value for this property and set the value for the `job_type` property to `ONE_TIME`. (documented below)
     */
    @JvmName("khwgecsdponhgkdu")
    public suspend
    fun scheduleFrequency(argument: suspend ClassificationJobScheduleFrequencyArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationJobScheduleFrequencyArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.scheduleFrequency = mapped
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    @JvmName("dkqktivksojlgmtu")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of key-value pairs that specifies the tags to associate with the job. A job can have a maximum of 50 tags. Each tag consists of a tag key and an associated tag value. The maximum length of a tag key is 128 characters. The maximum length of a tag value is 256 characters.
     */
    @JvmName("ncxniabodtsqvogd")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ClassificationJobArgs = ClassificationJobArgs(
        customDataIdentifierIds = customDataIdentifierIds,
        description = description,
        initialRun = initialRun,
        jobStatus = jobStatus,
        jobType = jobType,
        name = name,
        namePrefix = namePrefix,
        s3JobDefinition = s3JobDefinition,
        samplingPercentage = samplingPercentage,
        scheduleFrequency = scheduleFrequency,
        tags = tags,
    )
}
