@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [InvitationAccepter].
 */
@PulumiTagMarker
public class InvitationAccepterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InvitationAccepterArgs = InvitationAccepterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InvitationAccepterArgsBuilder.() -> Unit) {
        val builder = InvitationAccepterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InvitationAccepter {
        val builtJavaResource = com.pulumi.aws.macie2.InvitationAccepter(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InvitationAccepter(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Invitation Accepter](https://docs.aws.amazon.com/macie/latest/APIReference/invitations-accept.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.AccountArgs;
 * import com.pulumi.aws.macie2.Member;
 * import com.pulumi.aws.macie2.MemberArgs;
 * import com.pulumi.aws.macie2.InvitationAccepter;
 * import com.pulumi.aws.macie2.InvitationAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primaryAccount = new Account("primaryAccount", AccountArgs.Empty, CustomResourceOptions.builder()
 *             .provider("awsalternate")
 *             .build());
 *         var memberAccount = new Account("memberAccount");
 *         var primaryMember = new Member("primaryMember", MemberArgs.builder()
 *             .accountId("ACCOUNT ID")
 *             .email("EMAIL")
 *             .invite(true)
 *             .invitationMessage("Message of the invite")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("awsalternate")
 *                 .dependsOn(primaryAccount)
 *                 .build());
 *         var memberInvitationAccepter = new InvitationAccepter("memberInvitationAccepter", InvitationAccepterArgs.builder()
 *             .administratorAccountId("ADMINISTRATOR ACCOUNT ID")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primaryMember)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_invitation_accepter` using the admin account ID. For example:
 * ```sh
 *  $ pulumi import aws:macie2/invitationAccepter:InvitationAccepter example 123456789012
 * ```
 *
 */
public class InvitationAccepter internal constructor(
    override val javaResource: com.pulumi.aws.macie2.InvitationAccepter,
) : KotlinCustomResource(javaResource, InvitationAccepterMapper) {
    /**
     * The AWS account ID for the account that sent the invitation.
     */
    public val administratorAccountId: Output<String>
        get() = javaResource.administratorAccountId().applyValue({ args0 -> args0 })

    /**
     * The unique identifier for the invitation.
     */
    public val invitationId: Output<String>
        get() = javaResource.invitationId().applyValue({ args0 -> args0 })
}

public object InvitationAccepterMapper : ResourceMapper<InvitationAccepter> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.InvitationAccepter::class == javaResource::class

    override fun map(javaResource: Resource): InvitationAccepter = InvitationAccepter(
        javaResource as
            com.pulumi.aws.macie2.InvitationAccepter,
    )
}

/**
 * @see [InvitationAccepter].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InvitationAccepter].
 */
public suspend fun invitationAccepter(
    name: String,
    block: suspend InvitationAccepterResourceBuilder.() -> Unit,
): InvitationAccepter {
    val builder = InvitationAccepterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InvitationAccepter].
 * @param name The _unique_ name of the resulting resource.
 */
public fun invitationAccepter(name: String): InvitationAccepter {
    val builder = InvitationAccepterResourceBuilder()
    builder.name(name)
    return builder.build()
}
