@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.InvitationAccepterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Macie Invitation Accepter](https://docs.aws.amazon.com/macie/latest/APIReference/invitations-accept.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.AccountArgs;
 * import com.pulumi.aws.macie2.Member;
 * import com.pulumi.aws.macie2.MemberArgs;
 * import com.pulumi.aws.macie2.InvitationAccepter;
 * import com.pulumi.aws.macie2.InvitationAccepterArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var primaryAccount = new Account("primaryAccount", AccountArgs.Empty, CustomResourceOptions.builder()
 *             .provider("awsalternate")
 *             .build());
 *         var memberAccount = new Account("memberAccount");
 *         var primaryMember = new Member("primaryMember", MemberArgs.builder()
 *             .accountId("ACCOUNT ID")
 *             .email("EMAIL")
 *             .invite(true)
 *             .invitationMessage("Message of the invite")
 *             .build(), CustomResourceOptions.builder()
 *                 .provider("awsalternate")
 *                 .dependsOn(primaryAccount)
 *                 .build());
 *         var memberInvitationAccepter = new InvitationAccepter("memberInvitationAccepter", InvitationAccepterArgs.builder()
 *             .administratorAccountId("ADMINISTRATOR ACCOUNT ID")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(primaryMember)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_invitation_accepter` using the admin account ID. For example:
 * ```sh
 *  $ pulumi import aws:macie2/invitationAccepter:InvitationAccepter example 123456789012
 * ```
 * @property administratorAccountId The AWS account ID for the account that sent the invitation.
 */
public data class InvitationAccepterArgs(
    public val administratorAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.InvitationAccepterArgs> {
    override fun toJava(): com.pulumi.aws.macie2.InvitationAccepterArgs =
        com.pulumi.aws.macie2.InvitationAccepterArgs.builder()
            .administratorAccountId(administratorAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [InvitationAccepterArgs].
 */
@PulumiTagMarker
public class InvitationAccepterArgsBuilder internal constructor() {
    private var administratorAccountId: Output<String>? = null

    /**
     * @param value The AWS account ID for the account that sent the invitation.
     */
    @JvmName("ivlfmrhgrnahvfak")
    public suspend fun administratorAccountId(`value`: Output<String>) {
        this.administratorAccountId = value
    }

    /**
     * @param value The AWS account ID for the account that sent the invitation.
     */
    @JvmName("obceohihvvmdmeue")
    public suspend fun administratorAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.administratorAccountId = mapped
    }

    internal fun build(): InvitationAccepterArgs = InvitationAccepterArgs(
        administratorAccountId = administratorAccountId,
    )
}
