@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.MemberArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Macie Member](https://docs.aws.amazon.com/macie/latest/APIReference/members-id.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.Member;
 * import com.pulumi.aws.macie2.MemberArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleMember = new Member("exampleMember", MemberArgs.builder()
 *             .accountId("AWS ACCOUNT ID")
 *             .email("EMAIL")
 *             .invite(true)
 *             .invitationMessage("Message of the invitation")
 *             .invitationDisableEmailNotification(true)
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_member` using the account ID of the member account. For example:
 * ```sh
 *  $ pulumi import aws:macie2/member:Member example 123456789012
 * ```
 * @property accountId The AWS account ID for the account.
 * @property email The email address for the account.
 * @property invitationDisableEmailNotification Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. To send an email notification to the root user of each account, set this value to `true`.
 * @property invitationMessage A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.
 * @property invite Send an invitation to a member
 * @property status Specifies the status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to `ENABLED`. Valid values are `ENABLED` or `PAUSED`.
 * @property tags A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.
 */
public data class MemberArgs(
    public val accountId: Output<String>? = null,
    public val email: Output<String>? = null,
    public val invitationDisableEmailNotification: Output<Boolean>? = null,
    public val invitationMessage: Output<String>? = null,
    public val invite: Output<Boolean>? = null,
    public val status: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.MemberArgs> {
    override fun toJava(): com.pulumi.aws.macie2.MemberArgs =
        com.pulumi.aws.macie2.MemberArgs.builder()
            .accountId(accountId?.applyValue({ args0 -> args0 }))
            .email(email?.applyValue({ args0 -> args0 }))
            .invitationDisableEmailNotification(
                invitationDisableEmailNotification?.applyValue({ args0 ->
                    args0
                }),
            )
            .invitationMessage(invitationMessage?.applyValue({ args0 -> args0 }))
            .invite(invite?.applyValue({ args0 -> args0 }))
            .status(status?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [MemberArgs].
 */
@PulumiTagMarker
public class MemberArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var email: Output<String>? = null

    private var invitationDisableEmailNotification: Output<Boolean>? = null

    private var invitationMessage: Output<String>? = null

    private var invite: Output<Boolean>? = null

    private var status: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value The AWS account ID for the account.
     */
    @JvmName("plmarjxklhbhkxau")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value The email address for the account.
     */
    @JvmName("pvloladhjgvymana")
    public suspend fun email(`value`: Output<String>) {
        this.email = value
    }

    /**
     * @param value Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. To send an email notification to the root user of each account, set this value to `true`.
     */
    @JvmName("lbyqesbcvrsexgcr")
    public suspend fun invitationDisableEmailNotification(`value`: Output<Boolean>) {
        this.invitationDisableEmailNotification = value
    }

    /**
     * @param value A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.
     */
    @JvmName("pgrkjxumnrrwmrtf")
    public suspend fun invitationMessage(`value`: Output<String>) {
        this.invitationMessage = value
    }

    /**
     * @param value Send an invitation to a member
     */
    @JvmName("snluvldjgrpkqpbo")
    public suspend fun invite(`value`: Output<Boolean>) {
        this.invite = value
    }

    /**
     * @param value Specifies the status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to `ENABLED`. Valid values are `ENABLED` or `PAUSED`.
     */
    @JvmName("cwbhlucxilyfsfow")
    public suspend fun status(`value`: Output<String>) {
        this.status = value
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.
     */
    @JvmName("kbfjnanyxpuaxrgq")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The AWS account ID for the account.
     */
    @JvmName("nrvxwndsnwbywvkj")
    public suspend fun accountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value The email address for the account.
     */
    @JvmName("gprucgnpjopgnywv")
    public suspend fun email(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.email = mapped
    }

    /**
     * @param value Specifies whether to send an email notification to the root user of each account that the invitation will be sent to. This notification is in addition to an alert that the root user receives in AWS Personal Health Dashboard. To send an email notification to the root user of each account, set this value to `true`.
     */
    @JvmName("klbtwbjumuxqwugb")
    public suspend fun invitationDisableEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invitationDisableEmailNotification = mapped
    }

    /**
     * @param value A custom message to include in the invitation. Amazon Macie adds this message to the standard content that it sends for an invitation.
     */
    @JvmName("vxxegdetlofmpjpc")
    public suspend fun invitationMessage(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invitationMessage = mapped
    }

    /**
     * @param value Send an invitation to a member
     */
    @JvmName("hwdeluvfqoiefecr")
    public suspend fun invite(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.invite = mapped
    }

    /**
     * @param value Specifies the status for the account. To enable Amazon Macie and start all Macie activities for the account, set this value to `ENABLED`. Valid values are `ENABLED` or `PAUSED`.
     */
    @JvmName("rwgplvdvimfhmgcr")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.
     */
    @JvmName("sneqkorhuqwcksny")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of key-value pairs that specifies the tags to associate with the account in Amazon Macie.
     */
    @JvmName("woouchbbsobfassy")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): MemberArgs = MemberArgs(
        accountId = accountId,
        email = email,
        invitationDisableEmailNotification = invitationDisableEmailNotification,
        invitationMessage = invitationMessage,
        invite = invite,
        status = status,
        tags = tags,
    )
}
