@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [OrganizationAdminAccount].
 */
@PulumiTagMarker
public class OrganizationAdminAccountResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: OrganizationAdminAccountArgs = OrganizationAdminAccountArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend OrganizationAdminAccountArgsBuilder.() -> Unit) {
        val builder = OrganizationAdminAccountArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): OrganizationAdminAccount {
        val builtJavaResource = com.pulumi.aws.macie2.OrganizationAdminAccount(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return OrganizationAdminAccount(builtJavaResource)
    }
}

/**
 * Provides a resource to manage an [Amazon Macie Organization Admin Account](https://docs.aws.amazon.com/macie/latest/APIReference/admin.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.OrganizationAdminAccount;
 * import com.pulumi.aws.macie2.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("ID OF THE ADMIN ACCOUNT")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_organization_admin_account` using the id. For example:
 * ```sh
 *  $ pulumi import aws:macie2/organizationAdminAccount:OrganizationAdminAccount example abcd1
 * ```
 *
 */
public class OrganizationAdminAccount internal constructor(
    override val javaResource: com.pulumi.aws.macie2.OrganizationAdminAccount,
) : KotlinCustomResource(javaResource, OrganizationAdminAccountMapper) {
    /**
     * The AWS account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
     */
    public val adminAccountId: Output<String>
        get() = javaResource.adminAccountId().applyValue({ args0 -> args0 })
}

public object OrganizationAdminAccountMapper : ResourceMapper<OrganizationAdminAccount> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.macie2.OrganizationAdminAccount::class == javaResource::class

    override fun map(javaResource: Resource): OrganizationAdminAccount =
        OrganizationAdminAccount(javaResource as com.pulumi.aws.macie2.OrganizationAdminAccount)
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [OrganizationAdminAccount].
 */
public suspend fun organizationAdminAccount(
    name: String,
    block: suspend OrganizationAdminAccountResourceBuilder.() -> Unit,
): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [OrganizationAdminAccount].
 * @param name The _unique_ name of the resulting resource.
 */
public fun organizationAdminAccount(name: String): OrganizationAdminAccount {
    val builder = OrganizationAdminAccountResourceBuilder()
    builder.name(name)
    return builder.build()
}
