@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin

import com.pulumi.aws.macie2.OrganizationAdminAccountArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides a resource to manage an [Amazon Macie Organization Admin Account](https://docs.aws.amazon.com/macie/latest/APIReference/admin.html).
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.macie2.Account;
 * import com.pulumi.aws.macie2.OrganizationAdminAccount;
 * import com.pulumi.aws.macie2.OrganizationAdminAccountArgs;
 * import com.pulumi.resources.CustomResourceOptions;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleAccount = new Account("exampleAccount");
 *         var exampleOrganizationAdminAccount = new OrganizationAdminAccount("exampleOrganizationAdminAccount", OrganizationAdminAccountArgs.builder()
 *             .adminAccountId("ID OF THE ADMIN ACCOUNT")
 *             .build(), CustomResourceOptions.builder()
 *                 .dependsOn(exampleAccount)
 *                 .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import `aws_macie2_organization_admin_account` using the id. For example:
 * ```sh
 *  $ pulumi import aws:macie2/organizationAdminAccount:OrganizationAdminAccount example abcd1
 * ```
 * @property adminAccountId The AWS account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
 */
public data class OrganizationAdminAccountArgs(
    public val adminAccountId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.OrganizationAdminAccountArgs> {
    override fun toJava(): com.pulumi.aws.macie2.OrganizationAdminAccountArgs =
        com.pulumi.aws.macie2.OrganizationAdminAccountArgs.builder()
            .adminAccountId(adminAccountId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [OrganizationAdminAccountArgs].
 */
@PulumiTagMarker
public class OrganizationAdminAccountArgsBuilder internal constructor() {
    private var adminAccountId: Output<String>? = null

    /**
     * @param value The AWS account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
     */
    @JvmName("pupnadkqfhssrmxt")
    public suspend fun adminAccountId(`value`: Output<String>) {
        this.adminAccountId = value
    }

    /**
     * @param value The AWS account ID for the account to designate as the delegated Amazon Macie administrator account for the organization.
     */
    @JvmName("kbllqogydpbtnbdo")
    public suspend fun adminAccountId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.adminAccountId = mapped
    }

    internal fun build(): OrganizationAdminAccountArgs = OrganizationAdminAccountArgs(
        adminAccountId = adminAccountId,
    )
}
