@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property simpleCriterion A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
 * @property tagCriterion A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
 */
public data class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs(
    public val simpleCriterion:
    Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterionArgs>? = null,
    public val tagCriterion:
    Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs> {
    override fun toJava():
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs.builder()
            .simpleCriterion(simpleCriterion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagCriterion(tagCriterion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgsBuilder internal
constructor() {
    private var simpleCriterion:
        Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterionArgs>? = null

    private var tagCriterion:
        Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs>? = null

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("donvpnsvdhilumkp")
    public suspend
    fun simpleCriterion(`value`: Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterionArgs>) {
        this.simpleCriterion = value
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("yunxkflrgfnhvtgh")
    public suspend
    fun tagCriterion(`value`: Output<ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs>) {
        this.tagCriterion = value
    }

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("emrsbuuecntpuvib")
    public suspend
    fun simpleCriterion(`value`: ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simpleCriterion = mapped
    }

    /**
     * @param argument A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("iaxftfipgbwhmyea")
    public suspend
    fun simpleCriterion(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndSimpleCriterionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.simpleCriterion = mapped
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("bktmfmnpbaxhmmyc")
    public suspend
    fun tagCriterion(`value`: ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagCriterion = mapped
    }

    /**
     * @param argument A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("qcvpviattptdvfba")
    public suspend
    fun tagCriterion(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndTagCriterionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.tagCriterion = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs =
        ClassificationJobS3JobDefinitionBucketCriteriaExcludesAndArgs(
            simpleCriterion = simpleCriterion,
            tagCriterion = tagCriterion,
        )
}
