@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property simpleCriterion A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
 * @property tagCriterion A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
 */
public data class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs(
    public val simpleCriterion:
    Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterionArgs>? = null,
    public val tagCriterion:
    Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs> {
    override fun toJava():
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs.builder()
            .simpleCriterion(simpleCriterion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagCriterion(tagCriterion?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgsBuilder internal
constructor() {
    private var simpleCriterion:
        Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterionArgs>? = null

    private var tagCriterion:
        Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionArgs>? = null

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("lmdaldqshtemfgid")
    public suspend
    fun simpleCriterion(`value`: Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterionArgs>) {
        this.simpleCriterion = value
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("nmuayqcesemqjdqw")
    public suspend
    fun tagCriterion(`value`: Output<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionArgs>) {
        this.tagCriterion = value
    }

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("xnmrrvsjkyghjpfc")
    public suspend
    fun simpleCriterion(`value`: ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simpleCriterion = mapped
    }

    /**
     * @param argument A property-based condition that defines a property, operator, and one or more values for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("urxpdylrhvyhjrku")
    public suspend
    fun simpleCriterion(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndSimpleCriterionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.simpleCriterion = mapped
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("mnsusswvtuhpxtgv")
    public suspend
    fun tagCriterion(`value`: ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagCriterion = mapped
    }

    /**
     * @param argument A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an S3 buckets from the job. (documented below)
     */
    @JvmName("lhljulfyccmvkkku")
    public suspend
    fun tagCriterion(argument: suspend ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.tagCriterion = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs =
        ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndArgs(
            simpleCriterion = simpleCriterion,
            tagCriterion = tagCriterion,
        )
}
