@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketDefinitionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property accountId The unique identifier for the AWS account that owns the buckets.
 * @property buckets An array that lists the names of the buckets.
 */
public data class ClassificationJobS3JobDefinitionBucketDefinitionArgs(
    public val accountId: Output<String>,
    public val buckets: Output<List<String>>,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketDefinitionArgs> {
    override fun toJava():
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketDefinitionArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionBucketDefinitionArgs.builder()
            .accountId(accountId.applyValue({ args0 -> args0 }))
            .buckets(buckets.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionBucketDefinitionArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionBucketDefinitionArgsBuilder internal constructor() {
    private var accountId: Output<String>? = null

    private var buckets: Output<List<String>>? = null

    /**
     * @param value The unique identifier for the AWS account that owns the buckets.
     */
    @JvmName("tfcqiafcctcqctat")
    public suspend fun accountId(`value`: Output<String>) {
        this.accountId = value
    }

    /**
     * @param value An array that lists the names of the buckets.
     */
    @JvmName("bpirmbnujrpvjthr")
    public suspend fun buckets(`value`: Output<List<String>>) {
        this.buckets = value
    }

    @JvmName("gfjikocdisusmxot")
    public suspend fun buckets(vararg values: Output<String>) {
        this.buckets = Output.all(values.asList())
    }

    /**
     * @param values An array that lists the names of the buckets.
     */
    @JvmName("rkoshdtquarkhxtm")
    public suspend fun buckets(values: List<Output<String>>) {
        this.buckets = Output.all(values)
    }

    /**
     * @param value The unique identifier for the AWS account that owns the buckets.
     */
    @JvmName("jlpgputghxnqrqti")
    public suspend fun accountId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountId = mapped
    }

    /**
     * @param value An array that lists the names of the buckets.
     */
    @JvmName("xdaqlgykdnidfphp")
    public suspend fun buckets(`value`: List<String>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buckets = mapped
    }

    /**
     * @param values An array that lists the names of the buckets.
     */
    @JvmName("fhogjrctvjxilshq")
    public suspend fun buckets(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.buckets = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionBucketDefinitionArgs =
        ClassificationJobS3JobDefinitionBucketDefinitionArgs(
            accountId = accountId ?: throw PulumiNullFieldException("accountId"),
            buckets = buckets ?: throw PulumiNullFieldException("buckets"),
        )
}
