@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property excludes The property- or tag-based conditions that determine which objects to exclude from the analysis. (documented below)
 * @property includes The property- or tag-based conditions that determine which objects to include in the analysis. (documented below)
 */
public data class ClassificationJobS3JobDefinitionScopingArgs(
    public val excludes: Output<ClassificationJobS3JobDefinitionScopingExcludesArgs>? = null,
    public val includes: Output<ClassificationJobS3JobDefinitionScopingIncludesArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingArgs> {
    override fun toJava(): com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingArgs.builder()
            .excludes(excludes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .includes(includes?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingArgsBuilder internal constructor() {
    private var excludes: Output<ClassificationJobS3JobDefinitionScopingExcludesArgs>? = null

    private var includes: Output<ClassificationJobS3JobDefinitionScopingIncludesArgs>? = null

    /**
     * @param value The property- or tag-based conditions that determine which objects to exclude from the analysis. (documented below)
     */
    @JvmName("bwimlbfnuwsrsxrl")
    public suspend
    fun excludes(`value`: Output<ClassificationJobS3JobDefinitionScopingExcludesArgs>) {
        this.excludes = value
    }

    /**
     * @param value The property- or tag-based conditions that determine which objects to include in the analysis. (documented below)
     */
    @JvmName("ffhhtyxonlgrangt")
    public suspend
    fun includes(`value`: Output<ClassificationJobS3JobDefinitionScopingIncludesArgs>) {
        this.includes = value
    }

    /**
     * @param value The property- or tag-based conditions that determine which objects to exclude from the analysis. (documented below)
     */
    @JvmName("nyilyyveqaxkrntw")
    public suspend fun excludes(`value`: ClassificationJobS3JobDefinitionScopingExcludesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.excludes = mapped
    }

    /**
     * @param argument The property- or tag-based conditions that determine which objects to exclude from the analysis. (documented below)
     */
    @JvmName("kgvyyuxdoalkexpj")
    public suspend
    fun excludes(argument: suspend ClassificationJobS3JobDefinitionScopingExcludesArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationJobS3JobDefinitionScopingExcludesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.excludes = mapped
    }

    /**
     * @param value The property- or tag-based conditions that determine which objects to include in the analysis. (documented below)
     */
    @JvmName("ghjmofojqcipdxmd")
    public suspend fun includes(`value`: ClassificationJobS3JobDefinitionScopingIncludesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.includes = mapped
    }

    /**
     * @param argument The property- or tag-based conditions that determine which objects to include in the analysis. (documented below)
     */
    @JvmName("jeildpjcunvtglxn")
    public suspend
    fun includes(argument: suspend ClassificationJobS3JobDefinitionScopingIncludesArgsBuilder.() -> Unit) {
        val toBeMapped = ClassificationJobS3JobDefinitionScopingIncludesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.includes = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingArgs =
        ClassificationJobS3JobDefinitionScopingArgs(
            excludes = excludes,
            includes = includes,
        )
}
