@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.inputs

import com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property simpleScopeTerm A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
 * @property tagScopeTerm A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
 */
public data class ClassificationJobS3JobDefinitionScopingExcludesAndArgs(
    public val simpleScopeTerm:
    Output<ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs>? = null,
    public val tagScopeTerm:
    Output<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndArgs> {
    override fun toJava():
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndArgs =
        com.pulumi.aws.macie2.inputs.ClassificationJobS3JobDefinitionScopingExcludesAndArgs.builder()
            .simpleScopeTerm(simpleScopeTerm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .tagScopeTerm(tagScopeTerm?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ClassificationJobS3JobDefinitionScopingExcludesAndArgs].
 */
@PulumiTagMarker
public class ClassificationJobS3JobDefinitionScopingExcludesAndArgsBuilder internal constructor() {
    private var simpleScopeTerm:
        Output<ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs>? = null

    private var tagScopeTerm:
        Output<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs>? = null

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
     */
    @JvmName("undjridxsqssbtxq")
    public suspend
    fun simpleScopeTerm(`value`: Output<ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs>) {
        this.simpleScopeTerm = value
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
     */
    @JvmName("ulxdwjkkybncwakr")
    public suspend
    fun tagScopeTerm(`value`: Output<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs>) {
        this.tagScopeTerm = value
    }

    /**
     * @param value A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
     */
    @JvmName("antisqwucweafnwt")
    public suspend
    fun simpleScopeTerm(`value`: ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.simpleScopeTerm = mapped
    }

    /**
     * @param argument A property-based condition that defines a property, operator, and one or more values for including or excluding an object from the job. (documented below)
     */
    @JvmName("banscjmrrvpsdhuh")
    public suspend
    fun simpleScopeTerm(argument: suspend ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionScopingExcludesAndSimpleScopeTermArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.simpleScopeTerm = mapped
    }

    /**
     * @param value A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
     */
    @JvmName("cokivuknjesvtygj")
    public suspend
    fun tagScopeTerm(`value`: ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagScopeTerm = mapped
    }

    /**
     * @param argument A tag-based condition that defines the operator and tag keys or tag key and value pairs for including or excluding an object from the job. (documented below)
     */
    @JvmName("twmvaelnnixsodir")
    public suspend
    fun tagScopeTerm(argument: suspend ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgsBuilder.() -> Unit) {
        val toBeMapped =
            ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.tagScopeTerm = mapped
    }

    internal fun build(): ClassificationJobS3JobDefinitionScopingExcludesAndArgs =
        ClassificationJobS3JobDefinitionScopingExcludesAndArgs(
            simpleScopeTerm = simpleScopeTerm,
            tagScopeTerm = tagScopeTerm,
        )
}
