@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property bucketCriteria The property- and tag-based conditions that determine which S3 buckets to include or exclude from the analysis. Conflicts with `bucket_definitions`. (documented below)
 * @property bucketDefinitions An array of objects, one for each AWS account that owns buckets to analyze. Each object specifies the account ID for an account and one or more buckets to analyze for the account. Conflicts with `bucket_criteria`. (documented below)
 * @property scoping The property- and tag-based conditions that determine which objects to include or exclude from the analysis. (documented below)
 */
public data class ClassificationJobS3JobDefinition(
    public val bucketCriteria: ClassificationJobS3JobDefinitionBucketCriteria? = null,
    public val bucketDefinitions: List<ClassificationJobS3JobDefinitionBucketDefinition>? = null,
    public val scoping: ClassificationJobS3JobDefinitionScoping? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.macie2.outputs.ClassificationJobS3JobDefinition):
            ClassificationJobS3JobDefinition = ClassificationJobS3JobDefinition(
            bucketCriteria = javaType.bucketCriteria().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobS3JobDefinitionBucketCriteria.Companion.toKotlin(args0)
                })
            }).orElse(null),
            bucketDefinitions = javaType.bucketDefinitions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobS3JobDefinitionBucketDefinition.Companion.toKotlin(args0)
                })
            }),
            scoping = javaType.scoping().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobS3JobDefinitionScoping.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
