@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comparator The operator to use in the condition. Valid combination and values are available in the [AWS Documentation](https://docs.aws.amazon.com/macie/latest/APIReference/jobs.html#jobs-model-jobcomparator)
 * @property tagValues The  tag key and value pairs to use in the condition. One or more blocks are allowed. (documented below)
 */
public data class ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion(
    public val comparator: String? = null,
    public val tagValues:
    List<ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionTagValue>? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.macie2.outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion):
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion =
            ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterion(
                comparator = javaType.comparator().map({ args0 -> args0 }).orElse(null),
                tagValues = javaType.tagValues().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobS3JobDefinitionBucketCriteriaIncludesAndTagCriterionTagValue.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
