@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property accountId The unique identifier for the AWS account that owns the buckets.
 * @property buckets An array that lists the names of the buckets.
 */
public data class ClassificationJobS3JobDefinitionBucketDefinition(
    public val accountId: String,
    public val buckets: List<String>,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.macie2.outputs.ClassificationJobS3JobDefinitionBucketDefinition):
            ClassificationJobS3JobDefinitionBucketDefinition =
            ClassificationJobS3JobDefinitionBucketDefinition(
                accountId = javaType.accountId(),
                buckets = javaType.buckets().map({ args0 -> args0 }),
            )
    }
}
