@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.macie2.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property comparator The operator to use in the condition.
 * @property key The tag key to use in the condition. The only valid value is `TAG`.
 * @property tagValues The tag keys or tag key and value pairs to use in the condition.
 * @property target The type of object to apply the condition to. The only valid value is `S3_OBJECT`.
 */
public data class ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm(
    public val comparator: String? = null,
    public val key: String? = null,
    public val tagValues:
    List<ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValue>? = null,
    public val target: String? = null,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.aws.macie2.outputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm):
            ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm =
            ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTerm(
                comparator = javaType.comparator().map({ args0 -> args0 }).orElse(null),
                key = javaType.key().map({ args0 -> args0 }).orElse(null),
                tagValues = javaType.tagValues().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.macie2.kotlin.outputs.ClassificationJobS3JobDefinitionScopingExcludesAndTagScopeTermTagValue.Companion.toKotlin(args0)
                    })
                }),
                target = javaType.target().map({ args0 -> args0 }).orElse(null),
            )
    }
}
