@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediaconvert.kotlin

import com.pulumi.aws.mediaconvert.kotlin.outputs.QueueReservationPlanSettings
import com.pulumi.aws.mediaconvert.kotlin.outputs.QueueReservationPlanSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [Queue].
 */
@PulumiTagMarker
public class QueueResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: QueueArgs = QueueArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend QueueArgsBuilder.() -> Unit) {
        val builder = QueueArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Queue {
        val builtJavaResource = com.pulumi.aws.mediaconvert.Queue(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Queue(builtJavaResource)
    }
}

/**
 * Provides an AWS Elemental MediaConvert Queue.
 * ## Example Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.mediaconvert.Queue;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Queue("test");
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import Media Convert Queue using the queue name. For example:
 * ```sh
 *  $ pulumi import aws:mediaconvert/queue:Queue test tf-test-queue
 * ```
 *
 */
public class Queue internal constructor(
    override val javaResource: com.pulumi.aws.mediaconvert.Queue,
) : KotlinCustomResource(javaResource, QueueMapper) {
    /**
     * The Arn of the queue
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A description of the queue
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A unique identifier describing the queue
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies whether the pricing plan for the queue is on-demand or reserved. Valid values are `ON_DEMAND` or `RESERVED`. Default to `ON_DEMAND`.
     */
    public val pricingPlan: Output<String>?
        get() = javaResource.pricingPlan().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A detail pricing plan of the  reserved queue. See below.
     */
    public val reservationPlanSettings: Output<QueueReservationPlanSettings>
        get() = javaResource.reservationPlanSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })

    /**
     * A status of the queue. Valid values are `ACTIVE` or `RESERVED`. Default to `PAUSED`.
     */
    public val status: Output<String>?
        get() = javaResource.status().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * A map of tags to assign to the resource. .If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object QueueMapper : ResourceMapper<Queue> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.mediaconvert.Queue::class == javaResource::class

    override fun map(javaResource: Resource): Queue = Queue(
        javaResource as
            com.pulumi.aws.mediaconvert.Queue,
    )
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Queue].
 */
public suspend fun queue(name: String, block: suspend QueueResourceBuilder.() -> Unit): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Queue].
 * @param name The _unique_ name of the resulting resource.
 */
public fun queue(name: String): Queue {
    val builder = QueueResourceBuilder()
    builder.name(name)
    return builder.build()
}
