@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediaconvert.kotlin.inputs

import com.pulumi.aws.mediaconvert.inputs.GetQueuePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getQueue.
 * @property id Unique identifier of the queue. The same as `name`.
 * @property tags A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
 */
public data class GetQueuePlainArgs(
    public val id: String,
    public val tags: Map<String, String>? = null,
) : ConvertibleToJava<com.pulumi.aws.mediaconvert.inputs.GetQueuePlainArgs> {
    override fun toJava(): com.pulumi.aws.mediaconvert.inputs.GetQueuePlainArgs =
        com.pulumi.aws.mediaconvert.inputs.GetQueuePlainArgs.builder()
            .id(id.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() })).build()
}

/**
 * Builder for [GetQueuePlainArgs].
 */
@PulumiTagMarker
public class GetQueuePlainArgsBuilder internal constructor() {
    private var id: String? = null

    private var tags: Map<String, String>? = null

    /**
     * @param value Unique identifier of the queue. The same as `name`.
     */
    @JvmName("noqhcbqeqhiwehnt")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.id = mapped
    }

    /**
     * @param value A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("vgpccrwirvfoiebj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values A map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @JvmName("eajnudlqbevsrjcm")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    internal fun build(): GetQueuePlainArgs = GetQueuePlainArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        tags = tags,
    )
}
