@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediaconvert.kotlin.inputs

import com.pulumi.aws.mediaconvert.inputs.QueueReservationPlanSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property commitment The length of the term of your reserved queue pricing plan commitment. Valid value is `ONE_YEAR`.
 * @property renewalType Specifies whether the term of your reserved queue pricing plan. Valid values are `AUTO_RENEW` or `EXPIRE`.
 * @property reservedSlots Specifies the number of reserved transcode slots (RTS) for queue.
 */
public data class QueueReservationPlanSettingsArgs(
    public val commitment: Output<String>,
    public val renewalType: Output<String>,
    public val reservedSlots: Output<Int>,
) : ConvertibleToJava<com.pulumi.aws.mediaconvert.inputs.QueueReservationPlanSettingsArgs> {
    override fun toJava(): com.pulumi.aws.mediaconvert.inputs.QueueReservationPlanSettingsArgs =
        com.pulumi.aws.mediaconvert.inputs.QueueReservationPlanSettingsArgs.builder()
            .commitment(commitment.applyValue({ args0 -> args0 }))
            .renewalType(renewalType.applyValue({ args0 -> args0 }))
            .reservedSlots(reservedSlots.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [QueueReservationPlanSettingsArgs].
 */
@PulumiTagMarker
public class QueueReservationPlanSettingsArgsBuilder internal constructor() {
    private var commitment: Output<String>? = null

    private var renewalType: Output<String>? = null

    private var reservedSlots: Output<Int>? = null

    /**
     * @param value The length of the term of your reserved queue pricing plan commitment. Valid value is `ONE_YEAR`.
     */
    @JvmName("opavbgdvfacctuny")
    public suspend fun commitment(`value`: Output<String>) {
        this.commitment = value
    }

    /**
     * @param value Specifies whether the term of your reserved queue pricing plan. Valid values are `AUTO_RENEW` or `EXPIRE`.
     */
    @JvmName("ierhkbegfaxlwxqj")
    public suspend fun renewalType(`value`: Output<String>) {
        this.renewalType = value
    }

    /**
     * @param value Specifies the number of reserved transcode slots (RTS) for queue.
     */
    @JvmName("tbommgxtmxiyhufc")
    public suspend fun reservedSlots(`value`: Output<Int>) {
        this.reservedSlots = value
    }

    /**
     * @param value The length of the term of your reserved queue pricing plan commitment. Valid value is `ONE_YEAR`.
     */
    @JvmName("ngkdsioxdgdjwmvc")
    public suspend fun commitment(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.commitment = mapped
    }

    /**
     * @param value Specifies whether the term of your reserved queue pricing plan. Valid values are `AUTO_RENEW` or `EXPIRE`.
     */
    @JvmName("ymscxvwjlipcvfvr")
    public suspend fun renewalType(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.renewalType = mapped
    }

    /**
     * @param value Specifies the number of reserved transcode slots (RTS) for queue.
     */
    @JvmName("dqjfeqafswjmrujx")
    public suspend fun reservedSlots(`value`: Int) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.reservedSlots = mapped
    }

    internal fun build(): QueueReservationPlanSettingsArgs = QueueReservationPlanSettingsArgs(
        commitment = commitment ?: throw PulumiNullFieldException("commitment"),
        renewalType = renewalType ?: throw PulumiNullFieldException("renewalType"),
        reservedSlots = reservedSlots ?: throw PulumiNullFieldException("reservedSlots"),
    )
}
