@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.mediaconvert.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property commitment The length of the term of your reserved queue pricing plan commitment. Valid value is `ONE_YEAR`.
 * @property renewalType Specifies whether the term of your reserved queue pricing plan. Valid values are `AUTO_RENEW` or `EXPIRE`.
 * @property reservedSlots Specifies the number of reserved transcode slots (RTS) for queue.
 */
public data class QueueReservationPlanSettings(
    public val commitment: String,
    public val renewalType: String,
    public val reservedSlots: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.mediaconvert.outputs.QueueReservationPlanSettings):
            QueueReservationPlanSettings = QueueReservationPlanSettings(
            commitment = javaType.commitment(),
            renewalType = javaType.renewalType(),
            reservedSlots = javaType.reservedSlots(),
        )
    }
}
