@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.kotlin.outputs.ChannelCdiInputSpecification
import com.pulumi.aws.medialive.kotlin.outputs.ChannelDestination
import com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettings
import com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachment
import com.pulumi.aws.medialive.kotlin.outputs.ChannelInputSpecification
import com.pulumi.aws.medialive.kotlin.outputs.ChannelMaintenance
import com.pulumi.aws.medialive.kotlin.outputs.ChannelVpc
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.medialive.kotlin.outputs.ChannelCdiInputSpecification.Companion.toKotlin as channelCdiInputSpecificationToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.ChannelDestination.Companion.toKotlin as channelDestinationToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.ChannelEncoderSettings.Companion.toKotlin as channelEncoderSettingsToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.ChannelInputAttachment.Companion.toKotlin as channelInputAttachmentToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.ChannelInputSpecification.Companion.toKotlin as channelInputSpecificationToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.ChannelMaintenance.Companion.toKotlin as channelMaintenanceToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.ChannelVpc.Companion.toKotlin as channelVpcToKotlin

/**
 * Builder for [Channel].
 */
@PulumiTagMarker
public class ChannelResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ChannelArgs = ChannelArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ChannelArgsBuilder.() -> Unit) {
        val builder = ChannelArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Channel {
        val builtJavaResource = com.pulumi.aws.medialive.Channel(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Channel(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS MediaLive Channel.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.Channel;
 * import com.pulumi.aws.medialive.ChannelArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelInputSpecificationArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelDestinationArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsTimecodeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Channel("example", ChannelArgs.builder()
 *             .channelClass("STANDARD")
 *             .roleArn(aws_iam_role.example().arn())
 *             .inputSpecification(ChannelInputSpecificationArgs.builder()
 *                 .codec("AVC")
 *                 .inputResolution("HD")
 *                 .maximumBitrate("MAX_20_MBPS")
 *                 .build())
 *             .inputAttachments(ChannelInputAttachmentArgs.builder()
 *                 .inputAttachmentName("example-input")
 *                 .inputId(aws_medialive_input.example().id())
 *                 .build())
 *             .destinations(ChannelDestinationArgs.builder()
 *                 .id("destination")
 *                 .settings(
 *                     ChannelDestinationSettingArgs.builder()
 *                         .url(String.format("s3://%s/test1", aws_s3_bucket.main().id()))
 *                         .build(),
 *                     ChannelDestinationSettingArgs.builder()
 *                         .url(String.format("s3://%s/test2", aws_s3_bucket.main2().id()))
 *                         .build())
 *                 .build())
 *             .encoderSettings(ChannelEncoderSettingsArgs.builder()
 *                 .timecodeConfig(ChannelEncoderSettingsTimecodeConfigArgs.builder()
 *                     .source("EMBEDDED")
 *                     .build())
 *                 .audioDescriptions(ChannelEncoderSettingsAudioDescriptionArgs.builder()
 *                     .audioSelectorName("example audio selector")
 *                     .name("audio-selector")
 *                     .build())
 *                 .videoDescriptions(ChannelEncoderSettingsVideoDescriptionArgs.builder()
 *                     .name("example-video")
 *                     .build())
 *                 .outputGroups(ChannelEncoderSettingsOutputGroupArgs.builder()
 *                     .outputGroupSettings(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs.builder()
 *                         .archiveGroupSettings(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs.builder()
 *                             .destination(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs.builder()
 *                                 .destinationRefId("destination")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .outputs(ChannelEncoderSettingsOutputGroupOutputArgs.builder()
 *                         .outputName("example-name")
 *                         .videoDescriptionName("example-video")
 *                         .audioDescriptionNames("audio-selector")
 *                         .outputSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs.builder()
 *                             .archiveOutputSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs.builder()
 *                                 .nameModifier("_1")
 *                                 .extension("m2ts")
 *                                 .containerSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs.builder()
 *                                     .m2tsSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs.builder()
 *                                         .audioBufferModel("ATSC")
 *                                         .bufferModel("MULTIPLEX")
 *                                         .rateMode("CBR")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive Channel using the `channel_id`. For example:
 * ```sh
 *  $ pulumi import aws:medialive/channel:Channel example 1234567
 * ```
 *
 */
public class Channel internal constructor(
    override val javaResource: com.pulumi.aws.medialive.Channel,
) : KotlinCustomResource(javaResource, ChannelMapper) {
    /**
     * ARN of the Channel.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Specification of CDI inputs for this channel. See CDI Input Specification for more details.
     */
    public val cdiInputSpecification: Output<ChannelCdiInputSpecification>?
        get() = javaResource.cdiInputSpecification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> channelCdiInputSpecificationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Concise argument description.
     */
    public val channelClass: Output<String>
        get() = javaResource.channelClass().applyValue({ args0 -> args0 })

    /**
     * ID of the channel in MediaPackage that is the destination for this output group.
     */
    public val channelId: Output<String>
        get() = javaResource.channelId().applyValue({ args0 -> args0 })

    /**
     * Destinations for channel. See Destinations for more details.
     */
    public val destinations: Output<List<ChannelDestination>>
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    channelDestinationToKotlin(args0)
                })
            })
        })

    /**
     * Encoder settings. See Encoder Settings for more details.
     */
    public val encoderSettings: Output<ChannelEncoderSettings>
        get() = javaResource.encoderSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                channelEncoderSettingsToKotlin(args0)
            })
        })

    /**
     * Input attachments for the channel. See Input Attachments for more details.
     */
    public val inputAttachments: Output<List<ChannelInputAttachment>>
        get() = javaResource.inputAttachments().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> channelInputAttachmentToKotlin(args0) })
            })
        })

    /**
     * Specification of network and file inputs for the channel.
     */
    public val inputSpecification: Output<ChannelInputSpecification>
        get() = javaResource.inputSpecification().applyValue({ args0 ->
            args0.let({ args0 ->
                channelInputSpecificationToKotlin(args0)
            })
        })

    /**
     * The log level to write to Cloudwatch logs.
     */
    public val logLevel: Output<String>
        get() = javaResource.logLevel().applyValue({ args0 -> args0 })

    /**
     * Maintenance settings for this channel. See Maintenance for more details.
     */
    public val maintenance: Output<ChannelMaintenance>
        get() = javaResource.maintenance().applyValue({ args0 ->
            args0.let({ args0 ->
                channelMaintenanceToKotlin(args0)
            })
        })

    /**
     * Name of the Channel.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Concise argument description.
     */
    public val roleArn: Output<String>?
        get() = javaResource.roleArn().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Whether to start/stop channel. Default: `false`
     */
    public val startChannel: Output<Boolean>?
        get() = javaResource.startChannel().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Settings for the VPC outputs. See VPC for more details.
     */
    public val vpc: Output<ChannelVpc>?
        get() = javaResource.vpc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    channelVpcToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object ChannelMapper : ResourceMapper<Channel> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.medialive.Channel::class == javaResource::class

    override fun map(javaResource: Resource): Channel = Channel(
        javaResource as
            com.pulumi.aws.medialive.Channel,
    )
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Channel].
 */
public suspend fun channel(name: String, block: suspend ChannelResourceBuilder.() -> Unit):
    Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Channel].
 * @param name The _unique_ name of the resulting resource.
 */
public fun channel(name: String): Channel {
    val builder = ChannelResourceBuilder()
    builder.name(name)
    return builder.build()
}
