@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.ChannelArgs.builder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelCdiInputSpecificationArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelCdiInputSpecificationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelDestinationArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelDestinationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelEncoderSettingsArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelEncoderSettingsArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputAttachmentArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputAttachmentArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputSpecificationArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelInputSpecificationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelMaintenanceArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelMaintenanceArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.ChannelVpcArgs
import com.pulumi.aws.medialive.kotlin.inputs.ChannelVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS MediaLive Channel.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.Channel;
 * import com.pulumi.aws.medialive.ChannelArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelInputSpecificationArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelInputAttachmentArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelDestinationArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs;
 * import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsTimecodeConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Channel("example", ChannelArgs.builder()
 *             .channelClass("STANDARD")
 *             .roleArn(aws_iam_role.example().arn())
 *             .inputSpecification(ChannelInputSpecificationArgs.builder()
 *                 .codec("AVC")
 *                 .inputResolution("HD")
 *                 .maximumBitrate("MAX_20_MBPS")
 *                 .build())
 *             .inputAttachments(ChannelInputAttachmentArgs.builder()
 *                 .inputAttachmentName("example-input")
 *                 .inputId(aws_medialive_input.example().id())
 *                 .build())
 *             .destinations(ChannelDestinationArgs.builder()
 *                 .id("destination")
 *                 .settings(
 *                     ChannelDestinationSettingArgs.builder()
 *                         .url(String.format("s3://%s/test1", aws_s3_bucket.main().id()))
 *                         .build(),
 *                     ChannelDestinationSettingArgs.builder()
 *                         .url(String.format("s3://%s/test2", aws_s3_bucket.main2().id()))
 *                         .build())
 *                 .build())
 *             .encoderSettings(ChannelEncoderSettingsArgs.builder()
 *                 .timecodeConfig(ChannelEncoderSettingsTimecodeConfigArgs.builder()
 *                     .source("EMBEDDED")
 *                     .build())
 *                 .audioDescriptions(ChannelEncoderSettingsAudioDescriptionArgs.builder()
 *                     .audioSelectorName("example audio selector")
 *                     .name("audio-selector")
 *                     .build())
 *                 .videoDescriptions(ChannelEncoderSettingsVideoDescriptionArgs.builder()
 *                     .name("example-video")
 *                     .build())
 *                 .outputGroups(ChannelEncoderSettingsOutputGroupArgs.builder()
 *                     .outputGroupSettings(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArgs.builder()
 *                         .archiveGroupSettings(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingArgs.builder()
 *                             .destination(ChannelEncoderSettingsOutputGroupOutputGroupSettingsArchiveGroupSettingDestinationArgs.builder()
 *                                 .destinationRefId("destination")
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .outputs(ChannelEncoderSettingsOutputGroupOutputArgs.builder()
 *                         .outputName("example-name")
 *                         .videoDescriptionName("example-video")
 *                         .audioDescriptionNames("audio-selector")
 *                         .outputSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArgs.builder()
 *                             .archiveOutputSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsArgs.builder()
 *                                 .nameModifier("_1")
 *                                 .extension("m2ts")
 *                                 .containerSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsArgs.builder()
 *                                     .m2tsSettings(ChannelEncoderSettingsOutputGroupOutputOutputSettingsArchiveOutputSettingsContainerSettingsM2tsSettingsArgs.builder()
 *                                         .audioBufferModel("ATSC")
 *                                         .bufferModel("MULTIPLEX")
 *                                         .rateMode("CBR")
 *                                         .build())
 *                                     .build())
 *                                 .build())
 *                             .build())
 *                         .build())
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive Channel using the `channel_id`. For example:
 * ```sh
 *  $ pulumi import aws:medialive/channel:Channel example 1234567
 * ```
 * @property cdiInputSpecification Specification of CDI inputs for this channel. See CDI Input Specification for more details.
 * @property channelClass Concise argument description.
 * @property destinations Destinations for channel. See Destinations for more details.
 * @property encoderSettings Encoder settings. See Encoder Settings for more details.
 * @property inputAttachments Input attachments for the channel. See Input Attachments for more details.
 * @property inputSpecification Specification of network and file inputs for the channel.
 * @property logLevel The log level to write to Cloudwatch logs.
 * @property maintenance Maintenance settings for this channel. See Maintenance for more details.
 * @property name Name of the Channel.
 * The following arguments are optional:
 * @property roleArn Concise argument description.
 * @property startChannel Whether to start/stop channel. Default: `false`
 * @property tags A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpc Settings for the VPC outputs. See VPC for more details.
 */
public data class ChannelArgs(
    public val cdiInputSpecification: Output<ChannelCdiInputSpecificationArgs>? = null,
    public val channelClass: Output<String>? = null,
    public val destinations: Output<List<ChannelDestinationArgs>>? = null,
    public val encoderSettings: Output<ChannelEncoderSettingsArgs>? = null,
    public val inputAttachments: Output<List<ChannelInputAttachmentArgs>>? = null,
    public val inputSpecification: Output<ChannelInputSpecificationArgs>? = null,
    public val logLevel: Output<String>? = null,
    public val maintenance: Output<ChannelMaintenanceArgs>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val startChannel: Output<Boolean>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpc: Output<ChannelVpcArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.ChannelArgs> {
    override fun toJava(): com.pulumi.aws.medialive.ChannelArgs =
        com.pulumi.aws.medialive.ChannelArgs.builder()
            .cdiInputSpecification(
                cdiInputSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .channelClass(channelClass?.applyValue({ args0 -> args0 }))
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .encoderSettings(encoderSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .inputAttachments(
                inputAttachments?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputSpecification(
                inputSpecification?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .logLevel(logLevel?.applyValue({ args0 -> args0 }))
            .maintenance(maintenance?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .startChannel(startChannel?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpc(vpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ChannelArgs].
 */
@PulumiTagMarker
public class ChannelArgsBuilder internal constructor() {
    private var cdiInputSpecification: Output<ChannelCdiInputSpecificationArgs>? = null

    private var channelClass: Output<String>? = null

    private var destinations: Output<List<ChannelDestinationArgs>>? = null

    private var encoderSettings: Output<ChannelEncoderSettingsArgs>? = null

    private var inputAttachments: Output<List<ChannelInputAttachmentArgs>>? = null

    private var inputSpecification: Output<ChannelInputSpecificationArgs>? = null

    private var logLevel: Output<String>? = null

    private var maintenance: Output<ChannelMaintenanceArgs>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var startChannel: Output<Boolean>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpc: Output<ChannelVpcArgs>? = null

    /**
     * @param value Specification of CDI inputs for this channel. See CDI Input Specification for more details.
     */
    @JvmName("ugbsixfskqofvbut")
    public suspend fun cdiInputSpecification(`value`: Output<ChannelCdiInputSpecificationArgs>) {
        this.cdiInputSpecification = value
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("mjvetucukyyuoqar")
    public suspend fun channelClass(`value`: Output<String>) {
        this.channelClass = value
    }

    /**
     * @param value Destinations for channel. See Destinations for more details.
     */
    @JvmName("jueinrwpjkhqlcpx")
    public suspend fun destinations(`value`: Output<List<ChannelDestinationArgs>>) {
        this.destinations = value
    }

    @JvmName("cfjfnepmtigpoakw")
    public suspend fun destinations(vararg values: Output<ChannelDestinationArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values Destinations for channel. See Destinations for more details.
     */
    @JvmName("lbouparnsujepggh")
    public suspend fun destinations(values: List<Output<ChannelDestinationArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Encoder settings. See Encoder Settings for more details.
     */
    @JvmName("wkthjvwlrbdmlcdc")
    public suspend fun encoderSettings(`value`: Output<ChannelEncoderSettingsArgs>) {
        this.encoderSettings = value
    }

    /**
     * @param value Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("wusmyjgqennnwjec")
    public suspend fun inputAttachments(`value`: Output<List<ChannelInputAttachmentArgs>>) {
        this.inputAttachments = value
    }

    @JvmName("jmwidfyoytjonymo")
    public suspend fun inputAttachments(vararg values: Output<ChannelInputAttachmentArgs>) {
        this.inputAttachments = Output.all(values.asList())
    }

    /**
     * @param values Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("mribkfedhmjsnebe")
    public suspend fun inputAttachments(values: List<Output<ChannelInputAttachmentArgs>>) {
        this.inputAttachments = Output.all(values)
    }

    /**
     * @param value Specification of network and file inputs for the channel.
     */
    @JvmName("txqjlylsfnvcerlv")
    public suspend fun inputSpecification(`value`: Output<ChannelInputSpecificationArgs>) {
        this.inputSpecification = value
    }

    /**
     * @param value The log level to write to Cloudwatch logs.
     */
    @JvmName("kokrveeympmofyop")
    public suspend fun logLevel(`value`: Output<String>) {
        this.logLevel = value
    }

    /**
     * @param value Maintenance settings for this channel. See Maintenance for more details.
     */
    @JvmName("ubheeidopsyuqlne")
    public suspend fun maintenance(`value`: Output<ChannelMaintenanceArgs>) {
        this.maintenance = value
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("jmfckprqsppkfcwk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("mrwldaqiffcfyleg")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value Whether to start/stop channel. Default: `false`
     */
    @JvmName("pbphiqaxldeaydbq")
    public suspend fun startChannel(`value`: Output<Boolean>) {
        this.startChannel = value
    }

    /**
     * @param value A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("iohqtjwokhqjipji")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Settings for the VPC outputs. See VPC for more details.
     */
    @JvmName("dtdrkybcbfscfuoo")
    public suspend fun vpc(`value`: Output<ChannelVpcArgs>) {
        this.vpc = value
    }

    /**
     * @param value Specification of CDI inputs for this channel. See CDI Input Specification for more details.
     */
    @JvmName("xxuxajmsqoxbjtqo")
    public suspend fun cdiInputSpecification(`value`: ChannelCdiInputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cdiInputSpecification = mapped
    }

    /**
     * @param argument Specification of CDI inputs for this channel. See CDI Input Specification for more details.
     */
    @JvmName("thrjhemipjmlfxsv")
    public suspend
    fun cdiInputSpecification(argument: suspend ChannelCdiInputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelCdiInputSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.cdiInputSpecification = mapped
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("hmxljmuafgwqtuun")
    public suspend fun channelClass(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.channelClass = mapped
    }

    /**
     * @param value Destinations for channel. See Destinations for more details.
     */
    @JvmName("qwlfdjkovowqwvgv")
    public suspend fun destinations(`value`: List<ChannelDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument Destinations for channel. See Destinations for more details.
     */
    @JvmName("krlolhvbswwyebxi")
    public suspend
    fun destinations(argument: List<suspend ChannelDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destinations for channel. See Destinations for more details.
     */
    @JvmName("uowyuawkcknitkij")
    public suspend fun destinations(
        vararg
        argument: suspend ChannelDestinationArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destinations for channel. See Destinations for more details.
     */
    @JvmName("mvejgglcipiwgoda")
    public suspend fun destinations(argument: suspend ChannelDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChannelDestinationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values Destinations for channel. See Destinations for more details.
     */
    @JvmName("hqafjrotpxcxjtmj")
    public suspend fun destinations(vararg values: ChannelDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Encoder settings. See Encoder Settings for more details.
     */
    @JvmName("ultgbtapxnanhxbf")
    public suspend fun encoderSettings(`value`: ChannelEncoderSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encoderSettings = mapped
    }

    /**
     * @param argument Encoder settings. See Encoder Settings for more details.
     */
    @JvmName("ylftvkaoigtkeeyy")
    public suspend
    fun encoderSettings(argument: suspend ChannelEncoderSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encoderSettings = mapped
    }

    /**
     * @param value Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("gawmpqhdhkxcogyu")
    public suspend fun inputAttachments(`value`: List<ChannelInputAttachmentArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputAttachments = mapped
    }

    /**
     * @param argument Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("usnmnmqbftlwvmca")
    public suspend
    fun inputAttachments(argument: List<suspend ChannelInputAttachmentArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputAttachments = mapped
    }

    /**
     * @param argument Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("dgtrohoxqewelmic")
    public suspend fun inputAttachments(
        vararg
        argument: suspend ChannelInputAttachmentArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelInputAttachmentArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputAttachments = mapped
    }

    /**
     * @param argument Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("glyaggjhnsdmksmq")
    public suspend
    fun inputAttachments(argument: suspend ChannelInputAttachmentArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ChannelInputAttachmentArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputAttachments = mapped
    }

    /**
     * @param values Input attachments for the channel. See Input Attachments for more details.
     */
    @JvmName("tlxoquscrdwyakak")
    public suspend fun inputAttachments(vararg values: ChannelInputAttachmentArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputAttachments = mapped
    }

    /**
     * @param value Specification of network and file inputs for the channel.
     */
    @JvmName("fdxhtkbbdwbeahfi")
    public suspend fun inputSpecification(`value`: ChannelInputSpecificationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSpecification = mapped
    }

    /**
     * @param argument Specification of network and file inputs for the channel.
     */
    @JvmName("dbiurbcrocvtloef")
    public suspend
    fun inputSpecification(argument: suspend ChannelInputSpecificationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelInputSpecificationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.inputSpecification = mapped
    }

    /**
     * @param value The log level to write to Cloudwatch logs.
     */
    @JvmName("asfhatwwwmgrumlb")
    public suspend fun logLevel(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLevel = mapped
    }

    /**
     * @param value Maintenance settings for this channel. See Maintenance for more details.
     */
    @JvmName("ntlhnpuckgnkwdtp")
    public suspend fun maintenance(`value`: ChannelMaintenanceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maintenance = mapped
    }

    /**
     * @param argument Maintenance settings for this channel. See Maintenance for more details.
     */
    @JvmName("rypdhjvygrmblnpt")
    public suspend fun maintenance(argument: suspend ChannelMaintenanceArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelMaintenanceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.maintenance = mapped
    }

    /**
     * @param value Name of the Channel.
     * The following arguments are optional:
     */
    @JvmName("bcsadjmqvujtkjnk")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Concise argument description.
     */
    @JvmName("glcdekvjahrxjern")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value Whether to start/stop channel. Default: `false`
     */
    @JvmName("kvgaqkclaceptirw")
    public suspend fun startChannel(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startChannel = mapped
    }

    /**
     * @param value A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("umrcpefmerkxoidt")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the channel. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("uriogkujwhwlgmlk")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Settings for the VPC outputs. See VPC for more details.
     */
    @JvmName("oqtpngpxjbmavfcj")
    public suspend fun vpc(`value`: ChannelVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    /**
     * @param argument Settings for the VPC outputs. See VPC for more details.
     */
    @JvmName("qkyitljswmasexbw")
    public suspend fun vpc(argument: suspend ChannelVpcArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelVpcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpc = mapped
    }

    internal fun build(): ChannelArgs = ChannelArgs(
        cdiInputSpecification = cdiInputSpecification,
        channelClass = channelClass,
        destinations = destinations,
        encoderSettings = encoderSettings,
        inputAttachments = inputAttachments,
        inputSpecification = inputSpecification,
        logLevel = logLevel,
        maintenance = maintenance,
        name = name,
        roleArn = roleArn,
        startChannel = startChannel,
        tags = tags,
        vpc = vpc,
    )
}
