@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.kotlin.outputs.InputDestination
import com.pulumi.aws.medialive.kotlin.outputs.InputInputDevice
import com.pulumi.aws.medialive.kotlin.outputs.InputMediaConnectFlow
import com.pulumi.aws.medialive.kotlin.outputs.InputSource
import com.pulumi.aws.medialive.kotlin.outputs.InputVpc
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.medialive.kotlin.outputs.InputDestination.Companion.toKotlin as inputDestinationToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.InputInputDevice.Companion.toKotlin as inputInputDeviceToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.InputMediaConnectFlow.Companion.toKotlin as inputMediaConnectFlowToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.InputSource.Companion.toKotlin as inputSourceToKotlin
import com.pulumi.aws.medialive.kotlin.outputs.InputVpc.Companion.toKotlin as inputVpcToKotlin

/**
 * Builder for [Input].
 */
@PulumiTagMarker
public class InputResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InputArgs = InputArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InputArgsBuilder.() -> Unit) {
        val builder = InputArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Input {
        val builtJavaResource = com.pulumi.aws.medialive.Input(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Input(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS MediaLive Input.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.InputSecurityGroup;
 * import com.pulumi.aws.medialive.InputSecurityGroupArgs;
 * import com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs;
 * import com.pulumi.aws.medialive.Input;
 * import com.pulumi.aws.medialive.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleInputSecurityGroup = new InputSecurityGroup("exampleInputSecurityGroup", InputSecurityGroupArgs.builder()
 *             .whitelistRules(InputSecurityGroupWhitelistRuleArgs.builder()
 *                 .cidr("10.0.0.8/32")
 *                 .build())
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .build());
 *         var exampleInput = new Input("exampleInput", InputArgs.builder()
 *             .inputSecurityGroups(exampleInputSecurityGroup.id())
 *             .type("UDP_PUSH")
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive Input using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:medialive/input:Input example 12345678
 * ```
 *
 */
public class Input internal constructor(
    override val javaResource: com.pulumi.aws.medialive.Input,
) : KotlinCustomResource(javaResource, InputMapper) {
    /**
     * ARN of the Input.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Channels attached to Input.
     */
    public val attachedChannels: Output<List<String>>
        get() = javaResource.attachedChannels().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Destination settings for PUSH type inputs. See Destinations for more details.
     */
    public val destinations: Output<List<InputDestination>>?
        get() = javaResource.destinations().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 -> inputDestinationToKotlin(args0) })
                })
            }).orElse(null)
        })

    /**
     * The input class.
     */
    public val inputClass: Output<String>
        get() = javaResource.inputClass().applyValue({ args0 -> args0 })

    /**
     * Settings for the devices. See Input Devices for more details.
     */
    public val inputDevices: Output<List<InputInputDevice>>
        get() = javaResource.inputDevices().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    inputInputDeviceToKotlin(args0)
                })
            })
        })

    /**
     * A list of IDs for all Inputs which are partners of this one.
     */
    public val inputPartnerIds: Output<List<String>>
        get() = javaResource.inputPartnerIds().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * List of input security groups.
     */
    public val inputSecurityGroups: Output<List<String>>?
        get() = javaResource.inputSecurityGroups().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 -> args0 })
            }).orElse(null)
        })

    /**
     * Source type of the input.
     */
    public val inputSourceType: Output<String>
        get() = javaResource.inputSourceType().applyValue({ args0 -> args0 })

    /**
     * A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    public val mediaConnectFlows: Output<List<InputMediaConnectFlow>>
        get() = javaResource.mediaConnectFlows().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> inputMediaConnectFlowToKotlin(args0) })
            })
        })

    /**
     * Name of the input.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The ARN of the role this input assumes during and after creation.
     */
    public val roleArn: Output<String>
        get() = javaResource.roleArn().applyValue({ args0 -> args0 })

    /**
     * The source URLs for a PULL-type input. See Sources for more details.
     */
    public val sources: Output<List<InputSource>>
        get() = javaResource.sources().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    inputSourceToKotlin(args0)
                })
            })
        })

    /**
     * A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * The different types of inputs that AWS Elemental MediaLive supports.
     * The following arguments are optional:
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * Settings for a private VPC Input. See VPC for more details.
     */
    public val vpc: Output<InputVpc>?
        get() = javaResource.vpc().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    inputVpcToKotlin(args0)
                })
            }).orElse(null)
        })
}

public object InputMapper : ResourceMapper<Input> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.medialive.Input::class == javaResource::class

    override fun map(javaResource: Resource): Input = Input(
        javaResource as
            com.pulumi.aws.medialive.Input,
    )
}

/**
 * @see [Input].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Input].
 */
public suspend fun input(name: String, block: suspend InputResourceBuilder.() -> Unit): Input {
    val builder = InputResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Input].
 * @param name The _unique_ name of the resulting resource.
 */
public fun input(name: String): Input {
    val builder = InputResourceBuilder()
    builder.name(name)
    return builder.build()
}
