@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.InputArgs.builder
import com.pulumi.aws.medialive.kotlin.inputs.InputDestinationArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputDestinationArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputInputDeviceArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputInputDeviceArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputMediaConnectFlowArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputMediaConnectFlowArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputSourceArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputSourceArgsBuilder
import com.pulumi.aws.medialive.kotlin.inputs.InputVpcArgs
import com.pulumi.aws.medialive.kotlin.inputs.InputVpcArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS MediaLive Input.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.InputSecurityGroup;
 * import com.pulumi.aws.medialive.InputSecurityGroupArgs;
 * import com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs;
 * import com.pulumi.aws.medialive.Input;
 * import com.pulumi.aws.medialive.InputArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleInputSecurityGroup = new InputSecurityGroup("exampleInputSecurityGroup", InputSecurityGroupArgs.builder()
 *             .whitelistRules(InputSecurityGroupWhitelistRuleArgs.builder()
 *                 .cidr("10.0.0.8/32")
 *                 .build())
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .build());
 *         var exampleInput = new Input("exampleInput", InputArgs.builder()
 *             .inputSecurityGroups(exampleInputSecurityGroup.id())
 *             .type("UDP_PUSH")
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive Input using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:medialive/input:Input example 12345678
 * ```
 * @property destinations Destination settings for PUSH type inputs. See Destinations for more details.
 * @property inputDevices Settings for the devices. See Input Devices for more details.
 * @property inputSecurityGroups List of input security groups.
 * @property mediaConnectFlows A list of the MediaConnect Flows. See Media Connect Flows for more details.
 * @property name Name of the input.
 * @property roleArn The ARN of the role this input assumes during and after creation.
 * @property sources The source URLs for a PULL-type input. See Sources for more details.
 * @property tags A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property type The different types of inputs that AWS Elemental MediaLive supports.
 * The following arguments are optional:
 * @property vpc Settings for a private VPC Input. See VPC for more details.
 */
public data class InputArgs(
    public val destinations: Output<List<InputDestinationArgs>>? = null,
    public val inputDevices: Output<List<InputInputDeviceArgs>>? = null,
    public val inputSecurityGroups: Output<List<String>>? = null,
    public val mediaConnectFlows: Output<List<InputMediaConnectFlowArgs>>? = null,
    public val name: Output<String>? = null,
    public val roleArn: Output<String>? = null,
    public val sources: Output<List<InputSourceArgs>>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val type: Output<String>? = null,
    public val vpc: Output<InputVpcArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.InputArgs> {
    override fun toJava(): com.pulumi.aws.medialive.InputArgs =
        com.pulumi.aws.medialive.InputArgs.builder()
            .destinations(
                destinations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputDevices(
                inputDevices?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .inputSecurityGroups(inputSecurityGroups?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .mediaConnectFlows(
                mediaConnectFlows?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .name(name?.applyValue({ args0 -> args0 }))
            .roleArn(roleArn?.applyValue({ args0 -> args0 }))
            .sources(
                sources?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.applyValue({ args0 -> args0 }))
            .vpc(vpc?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [InputArgs].
 */
@PulumiTagMarker
public class InputArgsBuilder internal constructor() {
    private var destinations: Output<List<InputDestinationArgs>>? = null

    private var inputDevices: Output<List<InputInputDeviceArgs>>? = null

    private var inputSecurityGroups: Output<List<String>>? = null

    private var mediaConnectFlows: Output<List<InputMediaConnectFlowArgs>>? = null

    private var name: Output<String>? = null

    private var roleArn: Output<String>? = null

    private var sources: Output<List<InputSourceArgs>>? = null

    private var tags: Output<Map<String, String>>? = null

    private var type: Output<String>? = null

    private var vpc: Output<InputVpcArgs>? = null

    /**
     * @param value Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("gxutrlvvarsvyurh")
    public suspend fun destinations(`value`: Output<List<InputDestinationArgs>>) {
        this.destinations = value
    }

    @JvmName("lyhooycmopohdpax")
    public suspend fun destinations(vararg values: Output<InputDestinationArgs>) {
        this.destinations = Output.all(values.asList())
    }

    /**
     * @param values Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("irksqbxbtkbvilto")
    public suspend fun destinations(values: List<Output<InputDestinationArgs>>) {
        this.destinations = Output.all(values)
    }

    /**
     * @param value Settings for the devices. See Input Devices for more details.
     */
    @JvmName("yxjrmkyrwniqwqur")
    public suspend fun inputDevices(`value`: Output<List<InputInputDeviceArgs>>) {
        this.inputDevices = value
    }

    @JvmName("qoemfglyhfxvpsco")
    public suspend fun inputDevices(vararg values: Output<InputInputDeviceArgs>) {
        this.inputDevices = Output.all(values.asList())
    }

    /**
     * @param values Settings for the devices. See Input Devices for more details.
     */
    @JvmName("pbnakntkansmdjit")
    public suspend fun inputDevices(values: List<Output<InputInputDeviceArgs>>) {
        this.inputDevices = Output.all(values)
    }

    /**
     * @param value List of input security groups.
     */
    @JvmName("hyiarlujsouhbxth")
    public suspend fun inputSecurityGroups(`value`: Output<List<String>>) {
        this.inputSecurityGroups = value
    }

    @JvmName("jjwjgmpjnhygnnib")
    public suspend fun inputSecurityGroups(vararg values: Output<String>) {
        this.inputSecurityGroups = Output.all(values.asList())
    }

    /**
     * @param values List of input security groups.
     */
    @JvmName("jhjhtkknjfhhyexb")
    public suspend fun inputSecurityGroups(values: List<Output<String>>) {
        this.inputSecurityGroups = Output.all(values)
    }

    /**
     * @param value A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("wrcpltbpmlllgjnn")
    public suspend fun mediaConnectFlows(`value`: Output<List<InputMediaConnectFlowArgs>>) {
        this.mediaConnectFlows = value
    }

    @JvmName("ydwgwlryymmqtrke")
    public suspend fun mediaConnectFlows(vararg values: Output<InputMediaConnectFlowArgs>) {
        this.mediaConnectFlows = Output.all(values.asList())
    }

    /**
     * @param values A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("hlohuiyyvamoxeku")
    public suspend fun mediaConnectFlows(values: List<Output<InputMediaConnectFlowArgs>>) {
        this.mediaConnectFlows = Output.all(values)
    }

    /**
     * @param value Name of the input.
     */
    @JvmName("duxjpfafjsefrbvs")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The ARN of the role this input assumes during and after creation.
     */
    @JvmName("hqqplrgovoyevmxr")
    public suspend fun roleArn(`value`: Output<String>) {
        this.roleArn = value
    }

    /**
     * @param value The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("sivxsxyeijqeojua")
    public suspend fun sources(`value`: Output<List<InputSourceArgs>>) {
        this.sources = value
    }

    @JvmName("yhmehligdlwgsovn")
    public suspend fun sources(vararg values: Output<InputSourceArgs>) {
        this.sources = Output.all(values.asList())
    }

    /**
     * @param values The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("nambaxmxtixdlspu")
    public suspend fun sources(values: List<Output<InputSourceArgs>>) {
        this.sources = Output.all(values)
    }

    /**
     * @param value A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("pcoemuuochjtwbrj")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value The different types of inputs that AWS Elemental MediaLive supports.
     * The following arguments are optional:
     */
    @JvmName("iikfqckngpgerlxu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Settings for a private VPC Input. See VPC for more details.
     */
    @JvmName("hspbcwivixfnyaju")
    public suspend fun vpc(`value`: Output<InputVpcArgs>) {
        this.vpc = value
    }

    /**
     * @param value Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("oimjluygbfmltmls")
    public suspend fun destinations(`value`: List<InputDestinationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param argument Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("oxymipnittqexmgd")
    public suspend fun destinations(argument: List<suspend InputDestinationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InputDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("keydxjnaprefwpye")
    public suspend fun destinations(vararg argument: suspend InputDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InputDestinationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param argument Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("rhdspqquwxvhplyu")
    public suspend fun destinations(argument: suspend InputDestinationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputDestinationArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.destinations = mapped
    }

    /**
     * @param values Destination settings for PUSH type inputs. See Destinations for more details.
     */
    @JvmName("mfujnqjsbrmvwqnw")
    public suspend fun destinations(vararg values: InputDestinationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.destinations = mapped
    }

    /**
     * @param value Settings for the devices. See Input Devices for more details.
     */
    @JvmName("ruojcbosyahttokx")
    public suspend fun inputDevices(`value`: List<InputInputDeviceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputDevices = mapped
    }

    /**
     * @param argument Settings for the devices. See Input Devices for more details.
     */
    @JvmName("tdomuaigtntwnfqe")
    public suspend fun inputDevices(argument: List<suspend InputInputDeviceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InputInputDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputDevices = mapped
    }

    /**
     * @param argument Settings for the devices. See Input Devices for more details.
     */
    @JvmName("swnftrqembknfdhk")
    public suspend fun inputDevices(vararg argument: suspend InputInputDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            InputInputDeviceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.inputDevices = mapped
    }

    /**
     * @param argument Settings for the devices. See Input Devices for more details.
     */
    @JvmName("diaqistnikwakale")
    public suspend fun inputDevices(argument: suspend InputInputDeviceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputInputDeviceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.inputDevices = mapped
    }

    /**
     * @param values Settings for the devices. See Input Devices for more details.
     */
    @JvmName("gsprdmqhbpaifvig")
    public suspend fun inputDevices(vararg values: InputInputDeviceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputDevices = mapped
    }

    /**
     * @param value List of input security groups.
     */
    @JvmName("qruioifacnxttlbp")
    public suspend fun inputSecurityGroups(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inputSecurityGroups = mapped
    }

    /**
     * @param values List of input security groups.
     */
    @JvmName("upeduuwjunkarmxt")
    public suspend fun inputSecurityGroups(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.inputSecurityGroups = mapped
    }

    /**
     * @param value A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("jktyplgyfsulddtf")
    public suspend fun mediaConnectFlows(`value`: List<InputMediaConnectFlowArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaConnectFlows = mapped
    }

    /**
     * @param argument A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("wuowxvostbljkush")
    public suspend
    fun mediaConnectFlows(argument: List<suspend InputMediaConnectFlowArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            InputMediaConnectFlowArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaConnectFlows = mapped
    }

    /**
     * @param argument A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("sasqwqkrjqkwfibl")
    public suspend fun mediaConnectFlows(
        vararg
        argument: suspend InputMediaConnectFlowArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            InputMediaConnectFlowArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaConnectFlows = mapped
    }

    /**
     * @param argument A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("pwocincsjtxerxnr")
    public suspend
    fun mediaConnectFlows(argument: suspend InputMediaConnectFlowArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputMediaConnectFlowArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.mediaConnectFlows = mapped
    }

    /**
     * @param values A list of the MediaConnect Flows. See Media Connect Flows for more details.
     */
    @JvmName("nqrcxtngqivhyshl")
    public suspend fun mediaConnectFlows(vararg values: InputMediaConnectFlowArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mediaConnectFlows = mapped
    }

    /**
     * @param value Name of the input.
     */
    @JvmName("nocmsnktkdmhlara")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The ARN of the role this input assumes during and after creation.
     */
    @JvmName("lbhlcjqonfforwgj")
    public suspend fun roleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roleArn = mapped
    }

    /**
     * @param value The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("cqqsdjdhbqntunwp")
    public suspend fun sources(`value`: List<InputSourceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param argument The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("otunggbueowqqopu")
    public suspend fun sources(argument: List<suspend InputSourceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { InputSourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("euynsuohtcielawl")
    public suspend fun sources(vararg argument: suspend InputSourceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { InputSourceArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param argument The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("fdsualhwxweyhwua")
    public suspend fun sources(argument: suspend InputSourceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(InputSourceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sources = mapped
    }

    /**
     * @param values The source URLs for a PULL-type input. See Sources for more details.
     */
    @JvmName("dyatotlyapqqjiqo")
    public suspend fun sources(vararg values: InputSourceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sources = mapped
    }

    /**
     * @param value A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kmjrvfjomxfirikl")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values A map of tags to assign to the Input. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("eqgyhdybaasxtdgr")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value The different types of inputs that AWS Elemental MediaLive supports.
     * The following arguments are optional:
     */
    @JvmName("omxdsoscgvrlsvoo")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Settings for a private VPC Input. See VPC for more details.
     */
    @JvmName("cjyxliqweypuyfui")
    public suspend fun vpc(`value`: InputVpcArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpc = mapped
    }

    /**
     * @param argument Settings for a private VPC Input. See VPC for more details.
     */
    @JvmName("fefrvyvffdvxoyrt")
    public suspend fun vpc(argument: suspend InputVpcArgsBuilder.() -> Unit) {
        val toBeMapped = InputVpcArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpc = mapped
    }

    internal fun build(): InputArgs = InputArgs(
        destinations = destinations,
        inputDevices = inputDevices,
        inputSecurityGroups = inputSecurityGroups,
        mediaConnectFlows = mediaConnectFlows,
        name = name,
        roleArn = roleArn,
        sources = sources,
        tags = tags,
        type = type,
        vpc = vpc,
    )
}
