@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.kotlin.outputs.InputSecurityGroupWhitelistRule
import com.pulumi.aws.medialive.kotlin.outputs.InputSecurityGroupWhitelistRule.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [InputSecurityGroup].
 */
@PulumiTagMarker
public class InputSecurityGroupResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: InputSecurityGroupArgs = InputSecurityGroupArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend InputSecurityGroupArgsBuilder.() -> Unit) {
        val builder = InputSecurityGroupArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): InputSecurityGroup {
        val builtJavaResource = com.pulumi.aws.medialive.InputSecurityGroup(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return InputSecurityGroup(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS MediaLive InputSecurityGroup.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.medialive.InputSecurityGroup;
 * import com.pulumi.aws.medialive.InputSecurityGroupArgs;
 * import com.pulumi.aws.medialive.inputs.InputSecurityGroupWhitelistRuleArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new InputSecurityGroup("example", InputSecurityGroupArgs.builder()
 *             .tags(Map.of("ENVIRONMENT", "prod"))
 *             .whitelistRules(InputSecurityGroupWhitelistRuleArgs.builder()
 *                 .cidr("10.0.0.8/32")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive InputSecurityGroup using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:medialive/inputSecurityGroup:InputSecurityGroup example 123456
 * ```
 *
 */
public class InputSecurityGroup internal constructor(
    override val javaResource: com.pulumi.aws.medialive.InputSecurityGroup,
) : KotlinCustomResource(javaResource, InputSecurityGroupMapper) {
    /**
     * ARN of the InputSecurityGroup.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * The list of inputs currently using this InputSecurityGroup.
     */
    public val inputs: Output<List<String>>
        get() = javaResource.inputs().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * A map of tags to assign to the InputSecurityGroup. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Whitelist rules. See Whitelist Rules for more details.
     * The following arguments are optional:
     */
    public val whitelistRules: Output<List<InputSecurityGroupWhitelistRule>>
        get() = javaResource.whitelistRules().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })
}

public object InputSecurityGroupMapper : ResourceMapper<InputSecurityGroup> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.medialive.InputSecurityGroup::class == javaResource::class

    override fun map(javaResource: Resource): InputSecurityGroup = InputSecurityGroup(
        javaResource as
            com.pulumi.aws.medialive.InputSecurityGroup,
    )
}

/**
 * @see [InputSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [InputSecurityGroup].
 */
public suspend fun inputSecurityGroup(
    name: String,
    block: suspend InputSecurityGroupResourceBuilder.() -> Unit,
): InputSecurityGroup {
    val builder = InputSecurityGroupResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [InputSecurityGroup].
 * @param name The _unique_ name of the resulting resource.
 */
public fun inputSecurityGroup(name: String): InputSecurityGroup {
    val builder = InputSecurityGroupResourceBuilder()
    builder.name(name)
    return builder.build()
}
