@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.kotlin.outputs.MultiplexMultiplexSettings
import com.pulumi.aws.medialive.kotlin.outputs.MultiplexMultiplexSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [Multiplex].
 */
@PulumiTagMarker
public class MultiplexResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MultiplexArgs = MultiplexArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MultiplexArgsBuilder.() -> Unit) {
        val builder = MultiplexArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): Multiplex {
        val builtJavaResource = com.pulumi.aws.medialive.Multiplex(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Multiplex(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS MediaLive Multiplex.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.medialive.Multiplex;
 * import com.pulumi.aws.medialive.MultiplexArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         var example = new Multiplex("example", MultiplexArgs.builder()
 *             .availabilityZones(
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]),
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .multiplexSettings(MultiplexMultiplexSettingsArgs.builder()
 *                 .transportStreamBitrate(1000000)
 *                 .transportStreamId(1)
 *                 .transportStreamReservedBitrate(1)
 *                 .maximumVideoBufferDelayMilliseconds(1000)
 *                 .build())
 *             .startMultiplex(true)
 *             .tags(Map.of("tag1", "value1"))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive Multiplex using the `id`. For example:
 * ```sh
 *  $ pulumi import aws:medialive/multiplex:Multiplex example 12345678
 * ```
 *
 */
public class Multiplex internal constructor(
    override val javaResource: com.pulumi.aws.medialive.Multiplex,
) : KotlinCustomResource(javaResource, MultiplexMapper) {
    /**
     * ARN of the Multiplex.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * A list of availability zones. You must specify exactly two.
     */
    public val availabilityZones: Output<List<String>>
        get() = javaResource.availabilityZones().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Multiplex settings. See Multiplex Settings for more details.
     */
    public val multiplexSettings: Output<MultiplexMultiplexSettings>?
        get() = javaResource.multiplexSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * name of Multiplex.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Whether to start the Multiplex. Defaults to `false`.
     */
    public val startMultiplex: Output<Boolean>?
        get() = javaResource.startMultiplex().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * A map of tags to assign to the Multiplex. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object MultiplexMapper : ResourceMapper<Multiplex> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.medialive.Multiplex::class == javaResource::class

    override fun map(javaResource: Resource): Multiplex = Multiplex(
        javaResource as
            com.pulumi.aws.medialive.Multiplex,
    )
}

/**
 * @see [Multiplex].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Multiplex].
 */
public suspend fun multiplex(name: String, block: suspend MultiplexResourceBuilder.() -> Unit):
    Multiplex {
    val builder = MultiplexResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Multiplex].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multiplex(name: String): Multiplex {
    val builder = MultiplexResourceBuilder()
    builder.name(name)
    return builder.build()
}
