@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.kotlin.outputs.MultiplexProgramMultiplexProgramSettings
import com.pulumi.aws.medialive.kotlin.outputs.MultiplexProgramMultiplexProgramSettings.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [MultiplexProgram].
 */
@PulumiTagMarker
public class MultiplexProgramResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: MultiplexProgramArgs = MultiplexProgramArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend MultiplexProgramArgsBuilder.() -> Unit) {
        val builder = MultiplexProgramArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.opts(block)
    }

    internal fun build(): MultiplexProgram {
        val builtJavaResource = com.pulumi.aws.medialive.MultiplexProgram(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return MultiplexProgram(builtJavaResource)
    }
}

/**
 * Resource for managing an AWS MediaLive MultiplexProgram.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.medialive.Multiplex;
 * import com.pulumi.aws.medialive.MultiplexArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs;
 * import com.pulumi.aws.medialive.MultiplexProgram;
 * import com.pulumi.aws.medialive.MultiplexProgramArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         var exampleMultiplex = new Multiplex("exampleMultiplex", MultiplexArgs.builder()
 *             .availabilityZones(
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]),
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .multiplexSettings(MultiplexMultiplexSettingsArgs.builder()
 *                 .transportStreamBitrate(1000000)
 *                 .transportStreamId(1)
 *                 .transportStreamReservedBitrate(1)
 *                 .maximumVideoBufferDelayMilliseconds(1000)
 *                 .build())
 *             .startMultiplex(true)
 *             .tags(Map.of("tag1", "value1"))
 *             .build());
 *         var exampleMultiplexProgram = new MultiplexProgram("exampleMultiplexProgram", MultiplexProgramArgs.builder()
 *             .programName("example_program")
 *             .multiplexId(exampleMultiplex.id())
 *             .multiplexProgramSettings(MultiplexProgramMultiplexProgramSettingsArgs.builder()
 *                 .programNumber(1)
 *                 .preferredChannelPipeline("CURRENTLY_ACTIVE")
 *                 .videoSettings(MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs.builder()
 *                     .constantBitrate(100000)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive MultiplexProgram using the `id`, or a combination of "`program_name`/`multiplex_id`". For example:
 * ```sh
 *  $ pulumi import aws:medialive/multiplexProgram:MultiplexProgram example example_program/1234567
 * ```
 *
 */
public class MultiplexProgram internal constructor(
    override val javaResource: com.pulumi.aws.medialive.MultiplexProgram,
) : KotlinCustomResource(javaResource, MultiplexProgramMapper) {
    /**
     * Multiplex ID.
     */
    public val multiplexId: Output<String>
        get() = javaResource.multiplexId().applyValue({ args0 -> args0 })

    /**
     * MultiplexProgram settings. See Multiplex Program Settings for more details.
     * The following arguments are optional:
     */
    public val multiplexProgramSettings: Output<MultiplexProgramMultiplexProgramSettings>?
        get() = javaResource.multiplexProgramSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Unique program name.
     */
    public val programName: Output<String>
        get() = javaResource.programName().applyValue({ args0 -> args0 })
}

public object MultiplexProgramMapper : ResourceMapper<MultiplexProgram> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.medialive.MultiplexProgram::class == javaResource::class

    override fun map(javaResource: Resource): MultiplexProgram = MultiplexProgram(
        javaResource as
            com.pulumi.aws.medialive.MultiplexProgram,
    )
}

/**
 * @see [MultiplexProgram].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [MultiplexProgram].
 */
public suspend fun multiplexProgram(
    name: String,
    block: suspend MultiplexProgramResourceBuilder.() -> Unit,
): MultiplexProgram {
    val builder = MultiplexProgramResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [MultiplexProgram].
 * @param name The _unique_ name of the resulting resource.
 */
public fun multiplexProgram(name: String): MultiplexProgram {
    val builder = MultiplexProgramResourceBuilder()
    builder.name(name)
    return builder.build()
}
