@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin

import com.pulumi.aws.medialive.MultiplexProgramArgs.builder
import com.pulumi.aws.medialive.kotlin.inputs.MultiplexProgramMultiplexProgramSettingsArgs
import com.pulumi.aws.medialive.kotlin.inputs.MultiplexProgramMultiplexProgramSettingsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Resource for managing an AWS MediaLive MultiplexProgram.
 * ## Example Usage
 * ### Basic Usage
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.AwsFunctions;
 * import com.pulumi.aws.inputs.GetAvailabilityZonesArgs;
 * import com.pulumi.aws.medialive.Multiplex;
 * import com.pulumi.aws.medialive.MultiplexArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexMultiplexSettingsArgs;
 * import com.pulumi.aws.medialive.MultiplexProgram;
 * import com.pulumi.aws.medialive.MultiplexProgramArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsArgs;
 * import com.pulumi.aws.medialive.inputs.MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         final var available = AwsFunctions.getAvailabilityZones(GetAvailabilityZonesArgs.builder()
 *             .state("available")
 *             .build());
 *         var exampleMultiplex = new Multiplex("exampleMultiplex", MultiplexArgs.builder()
 *             .availabilityZones(
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[0]),
 *                 available.applyValue(getAvailabilityZonesResult -> getAvailabilityZonesResult.names()[1]))
 *             .multiplexSettings(MultiplexMultiplexSettingsArgs.builder()
 *                 .transportStreamBitrate(1000000)
 *                 .transportStreamId(1)
 *                 .transportStreamReservedBitrate(1)
 *                 .maximumVideoBufferDelayMilliseconds(1000)
 *                 .build())
 *             .startMultiplex(true)
 *             .tags(Map.of("tag1", "value1"))
 *             .build());
 *         var exampleMultiplexProgram = new MultiplexProgram("exampleMultiplexProgram", MultiplexProgramArgs.builder()
 *             .programName("example_program")
 *             .multiplexId(exampleMultiplex.id())
 *             .multiplexProgramSettings(MultiplexProgramMultiplexProgramSettingsArgs.builder()
 *                 .programNumber(1)
 *                 .preferredChannelPipeline("CURRENTLY_ACTIVE")
 *                 .videoSettings(MultiplexProgramMultiplexProgramSettingsVideoSettingsArgs.builder()
 *                     .constantBitrate(100000)
 *                     .build())
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * Using `pulumi import`, import MediaLive MultiplexProgram using the `id`, or a combination of "`program_name`/`multiplex_id`". For example:
 * ```sh
 *  $ pulumi import aws:medialive/multiplexProgram:MultiplexProgram example example_program/1234567
 * ```
 * @property multiplexId Multiplex ID.
 * @property multiplexProgramSettings MultiplexProgram settings. See Multiplex Program Settings for more details.
 * The following arguments are optional:
 * @property programName Unique program name.
 */
public data class MultiplexProgramArgs(
    public val multiplexId: Output<String>? = null,
    public val multiplexProgramSettings: Output<MultiplexProgramMultiplexProgramSettingsArgs>? = null,
    public val programName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.MultiplexProgramArgs> {
    override fun toJava(): com.pulumi.aws.medialive.MultiplexProgramArgs =
        com.pulumi.aws.medialive.MultiplexProgramArgs.builder()
            .multiplexId(multiplexId?.applyValue({ args0 -> args0 }))
            .multiplexProgramSettings(
                multiplexProgramSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .programName(programName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MultiplexProgramArgs].
 */
@PulumiTagMarker
public class MultiplexProgramArgsBuilder internal constructor() {
    private var multiplexId: Output<String>? = null

    private var multiplexProgramSettings: Output<MultiplexProgramMultiplexProgramSettingsArgs>? = null

    private var programName: Output<String>? = null

    /**
     * @param value Multiplex ID.
     */
    @JvmName("hgsqipcogaghqyal")
    public suspend fun multiplexId(`value`: Output<String>) {
        this.multiplexId = value
    }

    /**
     * @param value MultiplexProgram settings. See Multiplex Program Settings for more details.
     * The following arguments are optional:
     */
    @JvmName("wjbhifasytfypqai")
    public suspend
    fun multiplexProgramSettings(`value`: Output<MultiplexProgramMultiplexProgramSettingsArgs>) {
        this.multiplexProgramSettings = value
    }

    /**
     * @param value Unique program name.
     */
    @JvmName("hrqjtkkhrbhdsadl")
    public suspend fun programName(`value`: Output<String>) {
        this.programName = value
    }

    /**
     * @param value Multiplex ID.
     */
    @JvmName("fgkiecfttgucljie")
    public suspend fun multiplexId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiplexId = mapped
    }

    /**
     * @param value MultiplexProgram settings. See Multiplex Program Settings for more details.
     * The following arguments are optional:
     */
    @JvmName("oejjcohavovwpbgx")
    public suspend
    fun multiplexProgramSettings(`value`: MultiplexProgramMultiplexProgramSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiplexProgramSettings = mapped
    }

    /**
     * @param argument MultiplexProgram settings. See Multiplex Program Settings for more details.
     * The following arguments are optional:
     */
    @JvmName("oifueyppeyiufhtp")
    public suspend
    fun multiplexProgramSettings(argument: suspend MultiplexProgramMultiplexProgramSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = MultiplexProgramMultiplexProgramSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.multiplexProgramSettings = mapped
    }

    /**
     * @param value Unique program name.
     */
    @JvmName("ierijxoctxarahli")
    public suspend fun programName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.programName = mapped
    }

    internal fun build(): MultiplexProgramArgs = MultiplexProgramArgs(
        multiplexId = multiplexId,
        multiplexProgramSettings = multiplexProgramSettings,
        programName = programName,
    )
}
