@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelDestinationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property id User-specified id. Ths is used in an output group or an output.
 * @property mediaPackageSettings Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
 * @property multiplexSettings Destination settings for a Multiplex output; one destination for both encoders. See Multiplex Settings for more details.
 * @property settings Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
 */
public data class ChannelDestinationArgs(
    public val id: Output<String>,
    public val mediaPackageSettings: Output<List<ChannelDestinationMediaPackageSettingArgs>>? = null,
    public val multiplexSettings: Output<ChannelDestinationMultiplexSettingsArgs>? = null,
    public val settings: Output<List<ChannelDestinationSettingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelDestinationArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelDestinationArgs =
        com.pulumi.aws.medialive.inputs.ChannelDestinationArgs.builder()
            .id(id.applyValue({ args0 -> args0 }))
            .mediaPackageSettings(
                mediaPackageSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .multiplexSettings(multiplexSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .settings(
                settings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelDestinationArgs].
 */
@PulumiTagMarker
public class ChannelDestinationArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    private var mediaPackageSettings: Output<List<ChannelDestinationMediaPackageSettingArgs>>? = null

    private var multiplexSettings: Output<ChannelDestinationMultiplexSettingsArgs>? = null

    private var settings: Output<List<ChannelDestinationSettingArgs>>? = null

    /**
     * @param value User-specified id. Ths is used in an output group or an output.
     */
    @JvmName("ooawlkjskdrrylub")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
     */
    @JvmName("xxqafdhpmrxeiyvm")
    public suspend
    fun mediaPackageSettings(`value`: Output<List<ChannelDestinationMediaPackageSettingArgs>>) {
        this.mediaPackageSettings = value
    }

    @JvmName("xelobuywlnouyrwm")
    public suspend fun mediaPackageSettings(
        vararg
        values: Output<ChannelDestinationMediaPackageSettingArgs>,
    ) {
        this.mediaPackageSettings = Output.all(values.asList())
    }

    /**
     * @param values Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
     */
    @JvmName("jbiofhmtijosbmvd")
    public suspend
    fun mediaPackageSettings(values: List<Output<ChannelDestinationMediaPackageSettingArgs>>) {
        this.mediaPackageSettings = Output.all(values)
    }

    /**
     * @param value Destination settings for a Multiplex output; one destination for both encoders. See Multiplex Settings for more details.
     */
    @JvmName("tlnrnrkimhtlubgm")
    public suspend fun multiplexSettings(`value`: Output<ChannelDestinationMultiplexSettingsArgs>) {
        this.multiplexSettings = value
    }

    /**
     * @param value Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
     */
    @JvmName("fxqnmyvxbvqybhbp")
    public suspend fun settings(`value`: Output<List<ChannelDestinationSettingArgs>>) {
        this.settings = value
    }

    @JvmName("pdlbhpeqtovuheni")
    public suspend fun settings(vararg values: Output<ChannelDestinationSettingArgs>) {
        this.settings = Output.all(values.asList())
    }

    /**
     * @param values Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
     */
    @JvmName("hybayryuqwkdvxwt")
    public suspend fun settings(values: List<Output<ChannelDestinationSettingArgs>>) {
        this.settings = Output.all(values)
    }

    /**
     * @param value User-specified id. Ths is used in an output group or an output.
     */
    @JvmName("hsehdwckjjlokuur")
    public suspend fun id(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
     */
    @JvmName("xwfgaxltkjdgykxb")
    public suspend
    fun mediaPackageSettings(`value`: List<ChannelDestinationMediaPackageSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mediaPackageSettings = mapped
    }

    /**
     * @param argument Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
     */
    @JvmName("uyuibyjkhgnfuppq")
    public suspend
    fun mediaPackageSettings(argument: List<suspend ChannelDestinationMediaPackageSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationMediaPackageSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaPackageSettings = mapped
    }

    /**
     * @param argument Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
     */
    @JvmName("btbqgcqrfowtvcyf")
    public suspend fun mediaPackageSettings(
        vararg
        argument: suspend ChannelDestinationMediaPackageSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationMediaPackageSettingArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.mediaPackageSettings = mapped
    }

    /**
     * @param argument Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
     */
    @JvmName("rwmiqkgaopudnexv")
    public suspend
    fun mediaPackageSettings(argument: suspend ChannelDestinationMediaPackageSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelDestinationMediaPackageSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.mediaPackageSettings = mapped
    }

    /**
     * @param values Destination settings for a MediaPackage output; one destination for both encoders. See Media Package Settings for more details.
     */
    @JvmName("dfccbabwboqfbuav")
    public suspend fun mediaPackageSettings(
        vararg
        values: ChannelDestinationMediaPackageSettingArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.mediaPackageSettings = mapped
    }

    /**
     * @param value Destination settings for a Multiplex output; one destination for both encoders. See Multiplex Settings for more details.
     */
    @JvmName("scciduuinhogcamx")
    public suspend fun multiplexSettings(`value`: ChannelDestinationMultiplexSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.multiplexSettings = mapped
    }

    /**
     * @param argument Destination settings for a Multiplex output; one destination for both encoders. See Multiplex Settings for more details.
     */
    @JvmName("scnrmcmmcibcotmc")
    public suspend
    fun multiplexSettings(argument: suspend ChannelDestinationMultiplexSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelDestinationMultiplexSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.multiplexSettings = mapped
    }

    /**
     * @param value Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
     */
    @JvmName("ovtbwvskxhbkifkm")
    public suspend fun settings(`value`: List<ChannelDestinationSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    /**
     * @param argument Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
     */
    @JvmName("ggtejfjovvntjpyg")
    public suspend
    fun settings(argument: List<suspend ChannelDestinationSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
     */
    @JvmName("itfejbxijqfcoilw")
    public suspend fun settings(
        vararg
        argument: suspend ChannelDestinationSettingArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelDestinationSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param argument Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
     */
    @JvmName("ewegjklfbeutvpmm")
    public suspend fun settings(argument: suspend ChannelDestinationSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelDestinationSettingArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.settings = mapped
    }

    /**
     * @param values Destination settings for a standard output; one destination for each redundant encoder. See Settings for more details.
     */
    @JvmName("xsdohviumhbkcgtu")
    public suspend fun settings(vararg values: ChannelDestinationSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.settings = mapped
    }

    internal fun build(): ChannelDestinationArgs = ChannelDestinationArgs(
        id = id ?: throw PulumiNullFieldException("id"),
        mediaPackageSettings = mediaPackageSettings,
        multiplexSettings = multiplexSettings,
        settings = settings,
    )
}
