@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelDestinationMultiplexSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property multiplexId The ID of the Multiplex that the encoder is providing output to.
 * @property programName The program name of the Multiplex program that the encoder is providing output to.
 */
public data class ChannelDestinationMultiplexSettingsArgs(
    public val multiplexId: Output<String>,
    public val programName: Output<String>,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelDestinationMultiplexSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelDestinationMultiplexSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelDestinationMultiplexSettingsArgs.builder()
            .multiplexId(multiplexId.applyValue({ args0 -> args0 }))
            .programName(programName.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelDestinationMultiplexSettingsArgs].
 */
@PulumiTagMarker
public class ChannelDestinationMultiplexSettingsArgsBuilder internal constructor() {
    private var multiplexId: Output<String>? = null

    private var programName: Output<String>? = null

    /**
     * @param value The ID of the Multiplex that the encoder is providing output to.
     */
    @JvmName("rkcgjhiqkmoipgdk")
    public suspend fun multiplexId(`value`: Output<String>) {
        this.multiplexId = value
    }

    /**
     * @param value The program name of the Multiplex program that the encoder is providing output to.
     */
    @JvmName("opbudbxefdxxtmej")
    public suspend fun programName(`value`: Output<String>) {
        this.programName = value
    }

    /**
     * @param value The ID of the Multiplex that the encoder is providing output to.
     */
    @JvmName("lxtxweevlqfvjdlj")
    public suspend fun multiplexId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.multiplexId = mapped
    }

    /**
     * @param value The program name of the Multiplex program that the encoder is providing output to.
     */
    @JvmName("ciosanidmjapkmhy")
    public suspend fun programName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.programName = mapped
    }

    internal fun build(): ChannelDestinationMultiplexSettingsArgs =
        ChannelDestinationMultiplexSettingsArgs(
            multiplexId = multiplexId ?: throw PulumiNullFieldException("multiplexId"),
            programName = programName ?: throw PulumiNullFieldException("programName"),
        )
}
