@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property audioDescriptions Audio descriptions for the channel. See Audio Descriptions for more details.
 * @property availBlanking Settings for ad avail blanking. See Avail Blanking for more details.
 * @property captionDescriptions Caption Descriptions. See Caption Descriptions for more details.
 * @property globalConfiguration Configuration settings that apply to the event as a whole. See Global Configuration for more details.
 * @property motionGraphicsConfiguration Settings for motion graphics. See Motion Graphics Configuration for more details.
 * @property nielsenConfiguration Nielsen configuration settings. See Nielsen Configuration for more details.
 * @property outputGroups Output groups for the channel. See Output Groups for more details.
 * @property timecodeConfig Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
 * @property videoDescriptions Video Descriptions. See Video Descriptions for more details.
 */
public data class ChannelEncoderSettingsArgs(
    public val audioDescriptions: Output<List<ChannelEncoderSettingsAudioDescriptionArgs>>? = null,
    public val availBlanking: Output<ChannelEncoderSettingsAvailBlankingArgs>? = null,
    public val captionDescriptions: Output<List<ChannelEncoderSettingsCaptionDescriptionArgs>>? =
        null,
    public val globalConfiguration: Output<ChannelEncoderSettingsGlobalConfigurationArgs>? = null,
    public val motionGraphicsConfiguration:
    Output<ChannelEncoderSettingsMotionGraphicsConfigurationArgs>? = null,
    public val nielsenConfiguration: Output<ChannelEncoderSettingsNielsenConfigurationArgs>? = null,
    public val outputGroups: Output<List<ChannelEncoderSettingsOutputGroupArgs>>,
    public val timecodeConfig: Output<ChannelEncoderSettingsTimecodeConfigArgs>,
    public val videoDescriptions: Output<List<ChannelEncoderSettingsVideoDescriptionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsArgs.builder()
            .audioDescriptions(
                audioDescriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .availBlanking(availBlanking?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .captionDescriptions(
                captionDescriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .globalConfiguration(
                globalConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .motionGraphicsConfiguration(
                motionGraphicsConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .nielsenConfiguration(
                nielsenConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .outputGroups(
                outputGroups.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .timecodeConfig(timecodeConfig.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .videoDescriptions(
                videoDescriptions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsArgsBuilder internal constructor() {
    private var audioDescriptions: Output<List<ChannelEncoderSettingsAudioDescriptionArgs>>? = null

    private var availBlanking: Output<ChannelEncoderSettingsAvailBlankingArgs>? = null

    private var captionDescriptions: Output<List<ChannelEncoderSettingsCaptionDescriptionArgs>>? =
        null

    private var globalConfiguration: Output<ChannelEncoderSettingsGlobalConfigurationArgs>? = null

    private var motionGraphicsConfiguration:
        Output<ChannelEncoderSettingsMotionGraphicsConfigurationArgs>? = null

    private var nielsenConfiguration: Output<ChannelEncoderSettingsNielsenConfigurationArgs>? = null

    private var outputGroups: Output<List<ChannelEncoderSettingsOutputGroupArgs>>? = null

    private var timecodeConfig: Output<ChannelEncoderSettingsTimecodeConfigArgs>? = null

    private var videoDescriptions: Output<List<ChannelEncoderSettingsVideoDescriptionArgs>>? = null

    /**
     * @param value Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("jlfggfcjkyguywvt")
    public suspend
    fun audioDescriptions(`value`: Output<List<ChannelEncoderSettingsAudioDescriptionArgs>>) {
        this.audioDescriptions = value
    }

    @JvmName("malosxfltwaqawjo")
    public suspend fun audioDescriptions(
        vararg
        values: Output<ChannelEncoderSettingsAudioDescriptionArgs>,
    ) {
        this.audioDescriptions = Output.all(values.asList())
    }

    /**
     * @param values Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("dytkfnnxohtlhhlo")
    public suspend
    fun audioDescriptions(values: List<Output<ChannelEncoderSettingsAudioDescriptionArgs>>) {
        this.audioDescriptions = Output.all(values)
    }

    /**
     * @param value Settings for ad avail blanking. See Avail Blanking for more details.
     */
    @JvmName("inlpyqoalyaugqwn")
    public suspend fun availBlanking(`value`: Output<ChannelEncoderSettingsAvailBlankingArgs>) {
        this.availBlanking = value
    }

    /**
     * @param value Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("kxlbisugtxisiipa")
    public suspend
    fun captionDescriptions(`value`: Output<List<ChannelEncoderSettingsCaptionDescriptionArgs>>) {
        this.captionDescriptions = value
    }

    @JvmName("ecaioklohyftktqm")
    public suspend fun captionDescriptions(
        vararg
        values: Output<ChannelEncoderSettingsCaptionDescriptionArgs>,
    ) {
        this.captionDescriptions = Output.all(values.asList())
    }

    /**
     * @param values Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("syhgurhvtutmxnxf")
    public suspend
    fun captionDescriptions(values: List<Output<ChannelEncoderSettingsCaptionDescriptionArgs>>) {
        this.captionDescriptions = Output.all(values)
    }

    /**
     * @param value Configuration settings that apply to the event as a whole. See Global Configuration for more details.
     */
    @JvmName("escrqlticklhoqpi")
    public suspend
    fun globalConfiguration(`value`: Output<ChannelEncoderSettingsGlobalConfigurationArgs>) {
        this.globalConfiguration = value
    }

    /**
     * @param value Settings for motion graphics. See Motion Graphics Configuration for more details.
     */
    @JvmName("lfndbpybpincsqqn")
    public suspend
    fun motionGraphicsConfiguration(`value`: Output<ChannelEncoderSettingsMotionGraphicsConfigurationArgs>) {
        this.motionGraphicsConfiguration = value
    }

    /**
     * @param value Nielsen configuration settings. See Nielsen Configuration for more details.
     */
    @JvmName("snyxfrvihofigoef")
    public suspend
    fun nielsenConfiguration(`value`: Output<ChannelEncoderSettingsNielsenConfigurationArgs>) {
        this.nielsenConfiguration = value
    }

    /**
     * @param value Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("mmwmhfgkeyglvhhv")
    public suspend fun outputGroups(`value`: Output<List<ChannelEncoderSettingsOutputGroupArgs>>) {
        this.outputGroups = value
    }

    @JvmName("irijilidbtafpaja")
    public suspend fun outputGroups(vararg values: Output<ChannelEncoderSettingsOutputGroupArgs>) {
        this.outputGroups = Output.all(values.asList())
    }

    /**
     * @param values Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("laltfpyrqbpjicll")
    public suspend fun outputGroups(values: List<Output<ChannelEncoderSettingsOutputGroupArgs>>) {
        this.outputGroups = Output.all(values)
    }

    /**
     * @param value Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
     */
    @JvmName("jnugiwcgxyjiemyn")
    public suspend fun timecodeConfig(`value`: Output<ChannelEncoderSettingsTimecodeConfigArgs>) {
        this.timecodeConfig = value
    }

    /**
     * @param value Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("uapvrcshiqycuwsr")
    public suspend
    fun videoDescriptions(`value`: Output<List<ChannelEncoderSettingsVideoDescriptionArgs>>) {
        this.videoDescriptions = value
    }

    @JvmName("ksmjbqyeqynvdpnc")
    public suspend fun videoDescriptions(
        vararg
        values: Output<ChannelEncoderSettingsVideoDescriptionArgs>,
    ) {
        this.videoDescriptions = Output.all(values.asList())
    }

    /**
     * @param values Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("fyeyubqasnnwpvru")
    public suspend
    fun videoDescriptions(values: List<Output<ChannelEncoderSettingsVideoDescriptionArgs>>) {
        this.videoDescriptions = Output.all(values)
    }

    /**
     * @param value Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("krhqmxjueyxyndas")
    public suspend fun audioDescriptions(`value`: List<ChannelEncoderSettingsAudioDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.audioDescriptions = mapped
    }

    /**
     * @param argument Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("ydtpopbjueeagusi")
    public suspend
    fun audioDescriptions(argument: List<suspend ChannelEncoderSettingsAudioDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.audioDescriptions = mapped
    }

    /**
     * @param argument Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("hbsjtieganilgmic")
    public suspend fun audioDescriptions(
        vararg
        argument: suspend ChannelEncoderSettingsAudioDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsAudioDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.audioDescriptions = mapped
    }

    /**
     * @param argument Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("ndkuvwsklerdtepd")
    public suspend
    fun audioDescriptions(argument: suspend ChannelEncoderSettingsAudioDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsAudioDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.audioDescriptions = mapped
    }

    /**
     * @param values Audio descriptions for the channel. See Audio Descriptions for more details.
     */
    @JvmName("uxnfehprbajifnsm")
    public suspend fun audioDescriptions(vararg values: ChannelEncoderSettingsAudioDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.audioDescriptions = mapped
    }

    /**
     * @param value Settings for ad avail blanking. See Avail Blanking for more details.
     */
    @JvmName("jtayqohptrpfcsng")
    public suspend fun availBlanking(`value`: ChannelEncoderSettingsAvailBlankingArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availBlanking = mapped
    }

    /**
     * @param argument Settings for ad avail blanking. See Avail Blanking for more details.
     */
    @JvmName("xaswtmjmjlcutmti")
    public suspend
    fun availBlanking(argument: suspend ChannelEncoderSettingsAvailBlankingArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsAvailBlankingArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.availBlanking = mapped
    }

    /**
     * @param value Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("uvqugfvflbitrxit")
    public suspend
    fun captionDescriptions(`value`: List<ChannelEncoderSettingsCaptionDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.captionDescriptions = mapped
    }

    /**
     * @param argument Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("dptlnrdgkwboucpf")
    public suspend
    fun captionDescriptions(argument: List<suspend ChannelEncoderSettingsCaptionDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsCaptionDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.captionDescriptions = mapped
    }

    /**
     * @param argument Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("hulmjroatrcdofcf")
    public suspend fun captionDescriptions(
        vararg
        argument: suspend ChannelEncoderSettingsCaptionDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsCaptionDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.captionDescriptions = mapped
    }

    /**
     * @param argument Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("ajwjeybfvrckuuyp")
    public suspend
    fun captionDescriptions(argument: suspend ChannelEncoderSettingsCaptionDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsCaptionDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.captionDescriptions = mapped
    }

    /**
     * @param values Caption Descriptions. See Caption Descriptions for more details.
     */
    @JvmName("uvcvuswdbffkrmip")
    public suspend fun captionDescriptions(
        vararg
        values: ChannelEncoderSettingsCaptionDescriptionArgs,
    ) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.captionDescriptions = mapped
    }

    /**
     * @param value Configuration settings that apply to the event as a whole. See Global Configuration for more details.
     */
    @JvmName("dxyycjueqfnmacgq")
    public suspend fun globalConfiguration(`value`: ChannelEncoderSettingsGlobalConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.globalConfiguration = mapped
    }

    /**
     * @param argument Configuration settings that apply to the event as a whole. See Global Configuration for more details.
     */
    @JvmName("bklofcdyatjfegix")
    public suspend
    fun globalConfiguration(argument: suspend ChannelEncoderSettingsGlobalConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsGlobalConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.globalConfiguration = mapped
    }

    /**
     * @param value Settings for motion graphics. See Motion Graphics Configuration for more details.
     */
    @JvmName("sxvbrseabiacectx")
    public suspend
    fun motionGraphicsConfiguration(`value`: ChannelEncoderSettingsMotionGraphicsConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.motionGraphicsConfiguration = mapped
    }

    /**
     * @param argument Settings for motion graphics. See Motion Graphics Configuration for more details.
     */
    @JvmName("ftouxwsjohqpchol")
    public suspend
    fun motionGraphicsConfiguration(argument: suspend ChannelEncoderSettingsMotionGraphicsConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsMotionGraphicsConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.motionGraphicsConfiguration = mapped
    }

    /**
     * @param value Nielsen configuration settings. See Nielsen Configuration for more details.
     */
    @JvmName("nsbvlawtoqlilawf")
    public suspend
    fun nielsenConfiguration(`value`: ChannelEncoderSettingsNielsenConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.nielsenConfiguration = mapped
    }

    /**
     * @param argument Nielsen configuration settings. See Nielsen Configuration for more details.
     */
    @JvmName("xafnjwqphaejdokv")
    public suspend
    fun nielsenConfiguration(argument: suspend ChannelEncoderSettingsNielsenConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsNielsenConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.nielsenConfiguration = mapped
    }

    /**
     * @param value Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("khqggjygncslhell")
    public suspend fun outputGroups(`value`: List<ChannelEncoderSettingsOutputGroupArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputGroups = mapped
    }

    /**
     * @param argument Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("uyyguvaapseyvdat")
    public suspend
    fun outputGroups(argument: List<suspend ChannelEncoderSettingsOutputGroupArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputGroups = mapped
    }

    /**
     * @param argument Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("dejktgombvdihlni")
    public suspend fun outputGroups(
        vararg
        argument: suspend ChannelEncoderSettingsOutputGroupArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsOutputGroupArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.outputGroups = mapped
    }

    /**
     * @param argument Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("erklshwaqtumetuq")
    public suspend
    fun outputGroups(argument: suspend ChannelEncoderSettingsOutputGroupArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsOutputGroupArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.outputGroups = mapped
    }

    /**
     * @param values Output groups for the channel. See Output Groups for more details.
     */
    @JvmName("rmoecsnehmxncxfo")
    public suspend fun outputGroups(vararg values: ChannelEncoderSettingsOutputGroupArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.outputGroups = mapped
    }

    /**
     * @param value Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
     */
    @JvmName("ggtcvrummqkneeuv")
    public suspend fun timecodeConfig(`value`: ChannelEncoderSettingsTimecodeConfigArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.timecodeConfig = mapped
    }

    /**
     * @param argument Contains settings used to acquire and adjust timecode information from inputs. See Timecode Config for more details.
     */
    @JvmName("motvrmibaseurcmh")
    public suspend
    fun timecodeConfig(argument: suspend ChannelEncoderSettingsTimecodeConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ChannelEncoderSettingsTimecodeConfigArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.timecodeConfig = mapped
    }

    /**
     * @param value Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("ldrlksrgxrjxgeio")
    public suspend fun videoDescriptions(`value`: List<ChannelEncoderSettingsVideoDescriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.videoDescriptions = mapped
    }

    /**
     * @param argument Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("wjjnplenhoitywuo")
    public suspend
    fun videoDescriptions(argument: List<suspend ChannelEncoderSettingsVideoDescriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsVideoDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.videoDescriptions = mapped
    }

    /**
     * @param argument Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("aictadqoiycwawsl")
    public suspend fun videoDescriptions(
        vararg
        argument: suspend ChannelEncoderSettingsVideoDescriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            ChannelEncoderSettingsVideoDescriptionArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.videoDescriptions = mapped
    }

    /**
     * @param argument Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("byaoonehxvbepobu")
    public suspend
    fun videoDescriptions(argument: suspend ChannelEncoderSettingsVideoDescriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ChannelEncoderSettingsVideoDescriptionArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.videoDescriptions = mapped
    }

    /**
     * @param values Video Descriptions. See Video Descriptions for more details.
     */
    @JvmName("ovpqnbrhqciydgwi")
    public suspend fun videoDescriptions(vararg values: ChannelEncoderSettingsVideoDescriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.videoDescriptions = mapped
    }

    internal fun build(): ChannelEncoderSettingsArgs = ChannelEncoderSettingsArgs(
        audioDescriptions = audioDescriptions,
        availBlanking = availBlanking,
        captionDescriptions = captionDescriptions,
        globalConfiguration = globalConfiguration,
        motionGraphicsConfiguration = motionGraphicsConfiguration,
        nielsenConfiguration = nielsenConfiguration,
        outputGroups = outputGroups ?: throw PulumiNullFieldException("outputGroups"),
        timecodeConfig = timecodeConfig ?: throw PulumiNullFieldException("timecodeConfig"),
        videoDescriptions = videoDescriptions,
    )
}
