@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property algorithm Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification, itu17702 to the EBU R-128 specification.
 * @property algorithmControl Algorithm control for the audio description.
 * @property targetLkfs Target LKFS (loudness) to adjust volume to.
 */
public data class ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs(
    public val algorithm: Output<String>? = null,
    public val algorithmControl: Output<String>? = null,
    public val targetLkfs: Output<Double>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs.builder()
            .algorithm(algorithm?.applyValue({ args0 -> args0 }))
            .algorithmControl(algorithmControl?.applyValue({ args0 -> args0 }))
            .targetLkfs(targetLkfs?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgsBuilder internal
constructor() {
    private var algorithm: Output<String>? = null

    private var algorithmControl: Output<String>? = null

    private var targetLkfs: Output<Double>? = null

    /**
     * @param value Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification, itu17702 to the EBU R-128 specification.
     */
    @JvmName("niifxdxvbrbxuqly")
    public suspend fun algorithm(`value`: Output<String>) {
        this.algorithm = value
    }

    /**
     * @param value Algorithm control for the audio description.
     */
    @JvmName("gpysvjbwdyhwfxrt")
    public suspend fun algorithmControl(`value`: Output<String>) {
        this.algorithmControl = value
    }

    /**
     * @param value Target LKFS (loudness) to adjust volume to.
     */
    @JvmName("ugmlcakeugwsxlcx")
    public suspend fun targetLkfs(`value`: Output<Double>) {
        this.targetLkfs = value
    }

    /**
     * @param value Audio normalization algorithm to use. itu17701 conforms to the CALM Act specification, itu17702 to the EBU R-128 specification.
     */
    @JvmName("ichyddkanrpnsext")
    public suspend fun algorithm(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.algorithm = mapped
    }

    /**
     * @param value Algorithm control for the audio description.
     */
    @JvmName("ynhshqnwqcaenpcg")
    public suspend fun algorithmControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.algorithmControl = mapped
    }

    /**
     * @param value Target LKFS (loudness) to adjust volume to.
     */
    @JvmName("bujhndyaxesusbni")
    public suspend fun targetLkfs(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.targetLkfs = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionAudioNormalizationSettingsArgs(
            algorithm = algorithm,
            algorithmControl = algorithmControl,
            targetLkfs = targetLkfs,
        )
}
