@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property cbetCheckDigitString
 * @property cbetStepaside Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
 * @property csid CBET source ID to use in the watermark.
 */
public data class
ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs(
    public val cbetCheckDigitString: Output<String>,
    public val cbetStepaside: Output<String>,
    public val csid: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs.builder()
            .cbetCheckDigitString(cbetCheckDigitString.applyValue({ args0 -> args0 }))
            .cbetStepaside(cbetStepaside.applyValue({ args0 -> args0 }))
            .csid(csid.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgsBuilder
internal constructor() {
    private var cbetCheckDigitString: Output<String>? = null

    private var cbetStepaside: Output<String>? = null

    private var csid: Output<String>? = null

    /**
     * @param value
     */
    @JvmName("aoomepcoeqtyrjtl")
    public suspend fun cbetCheckDigitString(`value`: Output<String>) {
        this.cbetCheckDigitString = value
    }

    /**
     * @param value Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
     */
    @JvmName("plawmoxtpdwakwbx")
    public suspend fun cbetStepaside(`value`: Output<String>) {
        this.cbetStepaside = value
    }

    /**
     * @param value CBET source ID to use in the watermark.
     */
    @JvmName("nipcwldagudjmyfb")
    public suspend fun csid(`value`: Output<String>) {
        this.csid = value
    }

    /**
     * @param value
     */
    @JvmName("wfvbklptieyhdnss")
    public suspend fun cbetCheckDigitString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cbetCheckDigitString = mapped
    }

    /**
     * @param value Determines the method of CBET insertion mode when prior encoding is detected on the same layer.
     */
    @JvmName("vdpcgqgoayafrppx")
    public suspend fun cbetStepaside(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.cbetStepaside = mapped
    }

    /**
     * @param value CBET source ID to use in the watermark.
     */
    @JvmName("titlossumefeblyr")
    public suspend fun csid(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.csid = mapped
    }

    internal fun build():
        ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenCbetSettingsArgs(
            cbetCheckDigitString = cbetCheckDigitString ?: throw
                PulumiNullFieldException("cbetCheckDigitString"),
            cbetStepaside = cbetStepaside ?: throw PulumiNullFieldException("cbetStepaside"),
            csid = csid ?: throw PulumiNullFieldException("csid"),
        )
}
