@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property checkDigitString
 * @property sid The Nielsen Source ID to include in the watermark.
 */
public data class
ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs(
    public val checkDigitString: Output<String>,
    public val sid: Output<Double>,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs.builder()
            .checkDigitString(checkDigitString.applyValue({ args0 -> args0 }))
            .sid(sid.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs].
 */
@PulumiTagMarker
public class
ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgsBuilder
internal constructor() {
    private var checkDigitString: Output<String>? = null

    private var sid: Output<Double>? = null

    /**
     * @param value
     */
    @JvmName("dvhvqcobvukjqxsb")
    public suspend fun checkDigitString(`value`: Output<String>) {
        this.checkDigitString = value
    }

    /**
     * @param value The Nielsen Source ID to include in the watermark.
     */
    @JvmName("kenkarkyylvlatgc")
    public suspend fun sid(`value`: Output<Double>) {
        this.sid = value
    }

    /**
     * @param value
     */
    @JvmName("gaaexbsghihpejbp")
    public suspend fun checkDigitString(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.checkDigitString = mapped
    }

    /**
     * @param value The Nielsen Source ID to include in the watermark.
     */
    @JvmName("oujhufruavdysmgh")
    public suspend fun sid(`value`: Double) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sid = mapped
    }

    internal fun build():
        ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs =
        ChannelEncoderSettingsAudioDescriptionAudioWatermarkSettingsNielsenWatermarksSettingsNielsenNaesIiNwSettingArgs(
            checkDigitString = checkDigitString ?: throw PulumiNullFieldException("checkDigitString"),
            sid = sid ?: throw PulumiNullFieldException("sid"),
        )
}
