@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property bitrate Average bitrate in bits/second.
 * @property bitstreamMode Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
 * @property codingMode Mono, Stereo, or 5.1 channel layout.
 * @property dialnorm Sets the dialnorm of the output.
 * @property drcProfile If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
 * @property lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
 * @property metadataControl Metadata control.
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs(
    public val bitrate: Output<Double>? = null,
    public val bitstreamMode: Output<String>? = null,
    public val codingMode: Output<String>? = null,
    public val dialnorm: Output<Int>? = null,
    public val drcProfile: Output<String>? = null,
    public val lfeFilter: Output<String>? = null,
    public val metadataControl: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs.builder()
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .bitstreamMode(bitstreamMode?.applyValue({ args0 -> args0 }))
            .codingMode(codingMode?.applyValue({ args0 -> args0 }))
            .dialnorm(dialnorm?.applyValue({ args0 -> args0 }))
            .drcProfile(drcProfile?.applyValue({ args0 -> args0 }))
            .lfeFilter(lfeFilter?.applyValue({ args0 -> args0 }))
            .metadataControl(metadataControl?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgsBuilder internal
constructor() {
    private var bitrate: Output<Double>? = null

    private var bitstreamMode: Output<String>? = null

    private var codingMode: Output<String>? = null

    private var dialnorm: Output<Int>? = null

    private var drcProfile: Output<String>? = null

    private var lfeFilter: Output<String>? = null

    private var metadataControl: Output<String>? = null

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("pvficxkfiqhydnvu")
    public suspend fun bitrate(`value`: Output<Double>) {
        this.bitrate = value
    }

    /**
     * @param value Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
     */
    @JvmName("mujbtwvnfdunkidr")
    public suspend fun bitstreamMode(`value`: Output<String>) {
        this.bitstreamMode = value
    }

    /**
     * @param value Mono, Stereo, or 5.1 channel layout.
     */
    @JvmName("ejurmkafakcgbgmv")
    public suspend fun codingMode(`value`: Output<String>) {
        this.codingMode = value
    }

    /**
     * @param value Sets the dialnorm of the output.
     */
    @JvmName("ismiykkrcqokrlqk")
    public suspend fun dialnorm(`value`: Output<Int>) {
        this.dialnorm = value
    }

    /**
     * @param value If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
     */
    @JvmName("kvscgoitmshisvon")
    public suspend fun drcProfile(`value`: Output<String>) {
        this.drcProfile = value
    }

    /**
     * @param value When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
     */
    @JvmName("icbksvkpnybwximx")
    public suspend fun lfeFilter(`value`: Output<String>) {
        this.lfeFilter = value
    }

    /**
     * @param value Metadata control.
     */
    @JvmName("grkprienqdsxjode")
    public suspend fun metadataControl(`value`: Output<String>) {
        this.metadataControl = value
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("ddisghuqfoikxohw")
    public suspend fun bitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
     */
    @JvmName("ahvyoxihmuyiynjn")
    public suspend fun bitstreamMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitstreamMode = mapped
    }

    /**
     * @param value Mono, Stereo, or 5.1 channel layout.
     */
    @JvmName("iviboakrvieiogxq")
    public suspend fun codingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codingMode = mapped
    }

    /**
     * @param value Sets the dialnorm of the output.
     */
    @JvmName("oqdgybwgwvwxbtah")
    public suspend fun dialnorm(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialnorm = mapped
    }

    /**
     * @param value If set to filmStandard, adds dynamic range compression signaling to the output bitstream as defined in the Dolby Digital specification.
     */
    @JvmName("ksufvuuvvombpooi")
    public suspend fun drcProfile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drcProfile = mapped
    }

    /**
     * @param value When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
     */
    @JvmName("ykbuvtxgthkxppoe")
    public suspend fun lfeFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfeFilter = mapped
    }

    /**
     * @param value Metadata control.
     */
    @JvmName("ruykurcsiipopvas")
    public suspend fun metadataControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataControl = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs(
            bitrate = bitrate,
            bitstreamMode = bitstreamMode,
            codingMode = codingMode,
            dialnorm = dialnorm,
            drcProfile = drcProfile,
            lfeFilter = lfeFilter,
            metadataControl = metadataControl,
        )
}
