@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property aacSettings Aac Settings. See AAC Settings for more details.
 * @property ac3Settings Ac3 Settings. See AC3 Settings for more details.
 * @property eac3AtmosSettings Eac3 Atmos Settings. See EAC3 Atmos Settings
 * @property eac3Settings Eac3 Settings. See EAC3 Settings
 * @property mp2Settings
 * @property passThroughSettings
 * @property wavSettings
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs(
    public val aacSettings:
    Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs>? = null,
    public val ac3Settings:
    Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs>? = null,
    public val eac3AtmosSettings:
    Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs>? = null,
    public val eac3Settings:
    Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs>? = null,
    public val mp2Settings:
    Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs>? = null,
    public val passThroughSettings:
    Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettingsArgs>? = null,
    public val wavSettings:
    Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs.builder()
            .aacSettings(aacSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .ac3Settings(ac3Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eac3AtmosSettings(eac3AtmosSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .eac3Settings(eac3Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .mp2Settings(mp2Settings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .passThroughSettings(
                passThroughSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .wavSettings(wavSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsArgsBuilder internal constructor() {
    private var aacSettings:
        Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs>? = null

    private var ac3Settings:
        Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs>? = null

    private var eac3AtmosSettings:
        Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs>? = null

    private var eac3Settings:
        Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs>? = null

    private var mp2Settings:
        Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs>? = null

    private var passThroughSettings:
        Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettingsArgs>? = null

    private var wavSettings:
        Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs>? = null

    /**
     * @param value Aac Settings. See AAC Settings for more details.
     */
    @JvmName("bvjgwtplxdaurqne")
    public suspend
    fun aacSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs>) {
        this.aacSettings = value
    }

    /**
     * @param value Ac3 Settings. See AC3 Settings for more details.
     */
    @JvmName("ghqsweeoqbtjxmbw")
    public suspend
    fun ac3Settings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs>) {
        this.ac3Settings = value
    }

    /**
     * @param value Eac3 Atmos Settings. See EAC3 Atmos Settings
     */
    @JvmName("evcdgvxokjnsmiwu")
    public suspend
    fun eac3AtmosSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs>) {
        this.eac3AtmosSettings = value
    }

    /**
     * @param value Eac3 Settings. See EAC3 Settings
     */
    @JvmName("ymxvxtxdvosruttd")
    public suspend
    fun eac3Settings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs>) {
        this.eac3Settings = value
    }

    /**
     * @param value
     */
    @JvmName("wttvltmeywfyeios")
    public suspend
    fun mp2Settings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs>) {
        this.mp2Settings = value
    }

    /**
     * @param value
     */
    @JvmName("bdcjvurihenssiwe")
    public suspend
    fun passThroughSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettingsArgs>) {
        this.passThroughSettings = value
    }

    /**
     * @param value
     */
    @JvmName("nyqcncvsiccvlyik")
    public suspend
    fun wavSettings(`value`: Output<ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs>) {
        this.wavSettings = value
    }

    /**
     * @param value Aac Settings. See AAC Settings for more details.
     */
    @JvmName("cwybvoafvjrqyrus")
    public suspend
    fun aacSettings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aacSettings = mapped
    }

    /**
     * @param argument Aac Settings. See AAC Settings for more details.
     */
    @JvmName("nbhjbxuxcnupllfg")
    public suspend
    fun aacSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsAacSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.aacSettings = mapped
    }

    /**
     * @param value Ac3 Settings. See AC3 Settings for more details.
     */
    @JvmName("rhwtncrcbalsunfn")
    public suspend
    fun ac3Settings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ac3Settings = mapped
    }

    /**
     * @param argument Ac3 Settings. See AC3 Settings for more details.
     */
    @JvmName("ogdoijvfmjnptfmk")
    public suspend
    fun ac3Settings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsAc3SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ac3Settings = mapped
    }

    /**
     * @param value Eac3 Atmos Settings. See EAC3 Atmos Settings
     */
    @JvmName("lvoxpjbkqhpuaguc")
    public suspend
    fun eac3AtmosSettings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eac3AtmosSettings = mapped
    }

    /**
     * @param argument Eac3 Atmos Settings. See EAC3 Atmos Settings
     */
    @JvmName("ggvwtdjblyoxcvey")
    public suspend
    fun eac3AtmosSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3AtmosSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.eac3AtmosSettings = mapped
    }

    /**
     * @param value Eac3 Settings. See EAC3 Settings
     */
    @JvmName("eygnioyaeuapkprl")
    public suspend
    fun eac3Settings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.eac3Settings = mapped
    }

    /**
     * @param argument Eac3 Settings. See EAC3 Settings
     */
    @JvmName("uixapaxpnylnstbs")
    public suspend
    fun eac3Settings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.eac3Settings = mapped
    }

    /**
     * @param value
     */
    @JvmName("gnogqysjvkihomiv")
    public suspend
    fun mp2Settings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.mp2Settings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wfissmfkvkpsotns")
    public suspend
    fun mp2Settings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsMp2SettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.mp2Settings = mapped
    }

    /**
     * @param value
     */
    @JvmName("dfxnhixildttujuk")
    public suspend
    fun passThroughSettings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passThroughSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gtnbibkcqqepdkaw")
    public suspend
    fun passThroughSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsPassThroughSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.passThroughSettings = mapped
    }

    /**
     * @param value
     */
    @JvmName("jnuhgmhitkictsyl")
    public suspend
    fun wavSettings(`value`: ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wavSettings = mapped
    }

    /**
     * @param argument
     */
    @JvmName("wunfclbssnhrthhq")
    public suspend
    fun wavSettings(argument: suspend ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAudioDescriptionCodecSettingsWavSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.wavSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsArgs(
            aacSettings = aacSettings,
            ac3Settings = ac3Settings,
            eac3AtmosSettings = eac3AtmosSettings,
            eac3Settings = eac3Settings,
            mp2Settings = mp2Settings,
            passThroughSettings = passThroughSettings,
            wavSettings = wavSettings,
        )
}
