@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Double
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property attenuationControl Sets the attenuation control.
 * @property bitrate Average bitrate in bits/second.
 * @property bitstreamMode Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
 * @property codingMode Mono, Stereo, or 5.1 channel layout.
 * @property dcFilter
 * @property dialnorm Sets the dialnorm of the output.
 * @property drcLine Sets the Dolby dynamic range compression profile.
 * @property drcRf Sets the profile for heavy Dolby dynamic range compression.
 * @property lfeControl
 * @property lfeFilter When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
 * @property loRoCenterMixLevel
 * @property loRoSurroundMixLevel
 * @property ltRtCenterMixLevel
 * @property ltRtSurroundMixLevel
 * @property metadataControl Metadata control.
 * @property passthroughControl
 * @property phaseControl
 * @property stereoDownmix
 * @property surroundExMode
 * @property surroundMode
 */
public data class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs(
    public val attenuationControl: Output<String>? = null,
    public val bitrate: Output<Double>? = null,
    public val bitstreamMode: Output<String>? = null,
    public val codingMode: Output<String>? = null,
    public val dcFilter: Output<String>? = null,
    public val dialnorm: Output<Int>? = null,
    public val drcLine: Output<String>? = null,
    public val drcRf: Output<String>? = null,
    public val lfeControl: Output<String>? = null,
    public val lfeFilter: Output<String>? = null,
    public val loRoCenterMixLevel: Output<Double>? = null,
    public val loRoSurroundMixLevel: Output<Double>? = null,
    public val ltRtCenterMixLevel: Output<Double>? = null,
    public val ltRtSurroundMixLevel: Output<Double>? = null,
    public val metadataControl: Output<String>? = null,
    public val passthroughControl: Output<String>? = null,
    public val phaseControl: Output<String>? = null,
    public val stereoDownmix: Output<String>? = null,
    public val surroundExMode: Output<String>? = null,
    public val surroundMode: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs.builder()
            .attenuationControl(attenuationControl?.applyValue({ args0 -> args0 }))
            .bitrate(bitrate?.applyValue({ args0 -> args0 }))
            .bitstreamMode(bitstreamMode?.applyValue({ args0 -> args0 }))
            .codingMode(codingMode?.applyValue({ args0 -> args0 }))
            .dcFilter(dcFilter?.applyValue({ args0 -> args0 }))
            .dialnorm(dialnorm?.applyValue({ args0 -> args0 }))
            .drcLine(drcLine?.applyValue({ args0 -> args0 }))
            .drcRf(drcRf?.applyValue({ args0 -> args0 }))
            .lfeControl(lfeControl?.applyValue({ args0 -> args0 }))
            .lfeFilter(lfeFilter?.applyValue({ args0 -> args0 }))
            .loRoCenterMixLevel(loRoCenterMixLevel?.applyValue({ args0 -> args0 }))
            .loRoSurroundMixLevel(loRoSurroundMixLevel?.applyValue({ args0 -> args0 }))
            .ltRtCenterMixLevel(ltRtCenterMixLevel?.applyValue({ args0 -> args0 }))
            .ltRtSurroundMixLevel(ltRtSurroundMixLevel?.applyValue({ args0 -> args0 }))
            .metadataControl(metadataControl?.applyValue({ args0 -> args0 }))
            .passthroughControl(passthroughControl?.applyValue({ args0 -> args0 }))
            .phaseControl(phaseControl?.applyValue({ args0 -> args0 }))
            .stereoDownmix(stereoDownmix?.applyValue({ args0 -> args0 }))
            .surroundExMode(surroundExMode?.applyValue({ args0 -> args0 }))
            .surroundMode(surroundMode?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgsBuilder internal
constructor() {
    private var attenuationControl: Output<String>? = null

    private var bitrate: Output<Double>? = null

    private var bitstreamMode: Output<String>? = null

    private var codingMode: Output<String>? = null

    private var dcFilter: Output<String>? = null

    private var dialnorm: Output<Int>? = null

    private var drcLine: Output<String>? = null

    private var drcRf: Output<String>? = null

    private var lfeControl: Output<String>? = null

    private var lfeFilter: Output<String>? = null

    private var loRoCenterMixLevel: Output<Double>? = null

    private var loRoSurroundMixLevel: Output<Double>? = null

    private var ltRtCenterMixLevel: Output<Double>? = null

    private var ltRtSurroundMixLevel: Output<Double>? = null

    private var metadataControl: Output<String>? = null

    private var passthroughControl: Output<String>? = null

    private var phaseControl: Output<String>? = null

    private var stereoDownmix: Output<String>? = null

    private var surroundExMode: Output<String>? = null

    private var surroundMode: Output<String>? = null

    /**
     * @param value Sets the attenuation control.
     */
    @JvmName("ntoulaoslrbtvemt")
    public suspend fun attenuationControl(`value`: Output<String>) {
        this.attenuationControl = value
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("enpjttxcirwjspfb")
    public suspend fun bitrate(`value`: Output<Double>) {
        this.bitrate = value
    }

    /**
     * @param value Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
     */
    @JvmName("twdeikuwbctgynjk")
    public suspend fun bitstreamMode(`value`: Output<String>) {
        this.bitstreamMode = value
    }

    /**
     * @param value Mono, Stereo, or 5.1 channel layout.
     */
    @JvmName("fwjcvqsekxcyvrgi")
    public suspend fun codingMode(`value`: Output<String>) {
        this.codingMode = value
    }

    /**
     * @param value
     */
    @JvmName("bvlwxlpijnyhqbtp")
    public suspend fun dcFilter(`value`: Output<String>) {
        this.dcFilter = value
    }

    /**
     * @param value Sets the dialnorm of the output.
     */
    @JvmName("qvhgqoiiuipwusfu")
    public suspend fun dialnorm(`value`: Output<Int>) {
        this.dialnorm = value
    }

    /**
     * @param value Sets the Dolby dynamic range compression profile.
     */
    @JvmName("mlnarcpupmlgiecu")
    public suspend fun drcLine(`value`: Output<String>) {
        this.drcLine = value
    }

    /**
     * @param value Sets the profile for heavy Dolby dynamic range compression.
     */
    @JvmName("oncbxtrpdrfkmcuc")
    public suspend fun drcRf(`value`: Output<String>) {
        this.drcRf = value
    }

    /**
     * @param value
     */
    @JvmName("gcegcdpyegrvomcr")
    public suspend fun lfeControl(`value`: Output<String>) {
        this.lfeControl = value
    }

    /**
     * @param value When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
     */
    @JvmName("iutfiewxtmdummjj")
    public suspend fun lfeFilter(`value`: Output<String>) {
        this.lfeFilter = value
    }

    /**
     * @param value
     */
    @JvmName("qherqjdxnwrognal")
    public suspend fun loRoCenterMixLevel(`value`: Output<Double>) {
        this.loRoCenterMixLevel = value
    }

    /**
     * @param value
     */
    @JvmName("xtfntysnprptacdr")
    public suspend fun loRoSurroundMixLevel(`value`: Output<Double>) {
        this.loRoSurroundMixLevel = value
    }

    /**
     * @param value
     */
    @JvmName("wganqicdgxfswnfh")
    public suspend fun ltRtCenterMixLevel(`value`: Output<Double>) {
        this.ltRtCenterMixLevel = value
    }

    /**
     * @param value
     */
    @JvmName("mqvgrqwbwbkkoxyq")
    public suspend fun ltRtSurroundMixLevel(`value`: Output<Double>) {
        this.ltRtSurroundMixLevel = value
    }

    /**
     * @param value Metadata control.
     */
    @JvmName("osmnykepwfcbxbyl")
    public suspend fun metadataControl(`value`: Output<String>) {
        this.metadataControl = value
    }

    /**
     * @param value
     */
    @JvmName("vpbubvmuxivttlyq")
    public suspend fun passthroughControl(`value`: Output<String>) {
        this.passthroughControl = value
    }

    /**
     * @param value
     */
    @JvmName("emvpraogmikwjvax")
    public suspend fun phaseControl(`value`: Output<String>) {
        this.phaseControl = value
    }

    /**
     * @param value
     */
    @JvmName("eptnpbqcngabgmdk")
    public suspend fun stereoDownmix(`value`: Output<String>) {
        this.stereoDownmix = value
    }

    /**
     * @param value
     */
    @JvmName("sqsbxonofnkajtgn")
    public suspend fun surroundExMode(`value`: Output<String>) {
        this.surroundExMode = value
    }

    /**
     * @param value
     */
    @JvmName("ppmqyymouqlurqev")
    public suspend fun surroundMode(`value`: Output<String>) {
        this.surroundMode = value
    }

    /**
     * @param value Sets the attenuation control.
     */
    @JvmName("mpibpfedchmsgqvo")
    public suspend fun attenuationControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attenuationControl = mapped
    }

    /**
     * @param value Average bitrate in bits/second.
     */
    @JvmName("ylipoistptcaqmow")
    public suspend fun bitrate(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitrate = mapped
    }

    /**
     * @param value Specifies the bitstream mode (bsmod) for the emitted AC-3 stream.
     */
    @JvmName("rycudmsbfdgasjde")
    public suspend fun bitstreamMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.bitstreamMode = mapped
    }

    /**
     * @param value Mono, Stereo, or 5.1 channel layout.
     */
    @JvmName("ogcxunjgpjffmxyh")
    public suspend fun codingMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codingMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("rmprpdyagshceudi")
    public suspend fun dcFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dcFilter = mapped
    }

    /**
     * @param value Sets the dialnorm of the output.
     */
    @JvmName("waogatqjsqgmbhgl")
    public suspend fun dialnorm(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dialnorm = mapped
    }

    /**
     * @param value Sets the Dolby dynamic range compression profile.
     */
    @JvmName("vianxvrmuahpicja")
    public suspend fun drcLine(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drcLine = mapped
    }

    /**
     * @param value Sets the profile for heavy Dolby dynamic range compression.
     */
    @JvmName("dokhngonmmyppbaf")
    public suspend fun drcRf(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.drcRf = mapped
    }

    /**
     * @param value
     */
    @JvmName("eahqlpubexdokvjx")
    public suspend fun lfeControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfeControl = mapped
    }

    /**
     * @param value When set to enabled, applies a 120Hz lowpass filter to the LFE channel prior to encoding.
     */
    @JvmName("irfxtuufincdmoil")
    public suspend fun lfeFilter(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lfeFilter = mapped
    }

    /**
     * @param value
     */
    @JvmName("qbnhpxxkhilfbhfa")
    public suspend fun loRoCenterMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loRoCenterMixLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("ukmrwqerdrhiukbu")
    public suspend fun loRoSurroundMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loRoSurroundMixLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("pvrpyaprqqtbhftm")
    public suspend fun ltRtCenterMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltRtCenterMixLevel = mapped
    }

    /**
     * @param value
     */
    @JvmName("yjhoatordvodpkmr")
    public suspend fun ltRtSurroundMixLevel(`value`: Double?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ltRtSurroundMixLevel = mapped
    }

    /**
     * @param value Metadata control.
     */
    @JvmName("jqeflufopgrobsvo")
    public suspend fun metadataControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadataControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("cjvhwuxmmbadcuvh")
    public suspend fun passthroughControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.passthroughControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("qlmsicoqbuletdvp")
    public suspend fun phaseControl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phaseControl = mapped
    }

    /**
     * @param value
     */
    @JvmName("baipnucxthydnbpi")
    public suspend fun stereoDownmix(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.stereoDownmix = mapped
    }

    /**
     * @param value
     */
    @JvmName("xgcewkkdqsjdbwie")
    public suspend fun surroundExMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surroundExMode = mapped
    }

    /**
     * @param value
     */
    @JvmName("wwmetpotjmfgetwg")
    public suspend fun surroundMode(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.surroundMode = mapped
    }

    internal fun build(): ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs =
        ChannelEncoderSettingsAudioDescriptionCodecSettingsEac3SettingsArgs(
            attenuationControl = attenuationControl,
            bitrate = bitrate,
            bitstreamMode = bitstreamMode,
            codingMode = codingMode,
            dcFilter = dcFilter,
            dialnorm = dialnorm,
            drcLine = drcLine,
            drcRf = drcRf,
            lfeControl = lfeControl,
            lfeFilter = lfeFilter,
            loRoCenterMixLevel = loRoCenterMixLevel,
            loRoSurroundMixLevel = loRoSurroundMixLevel,
            ltRtCenterMixLevel = ltRtCenterMixLevel,
            ltRtSurroundMixLevel = ltRtSurroundMixLevel,
            metadataControl = metadataControl,
            passthroughControl = passthroughControl,
            phaseControl = phaseControl,
            stereoDownmix = stereoDownmix,
            surroundExMode = surroundExMode,
            surroundMode = surroundMode,
        )
}
