@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property availBlankingImage Blanking image to be used. See Avail Blanking Image for more details.
 * @property state When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
 */
public data class ChannelEncoderSettingsAvailBlankingArgs(
    public val availBlankingImage: Output<ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs>? =
        null,
    public val state: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingArgs> {
    override fun toJava(): com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsAvailBlankingArgs.builder()
            .availBlankingImage(
                availBlankingImage?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .state(state?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChannelEncoderSettingsAvailBlankingArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsAvailBlankingArgsBuilder internal constructor() {
    private var availBlankingImage: Output<ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs>? =
        null

    private var state: Output<String>? = null

    /**
     * @param value Blanking image to be used. See Avail Blanking Image for more details.
     */
    @JvmName("vwtvtyhricowkgse")
    public suspend
    fun availBlankingImage(`value`: Output<ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs>) {
        this.availBlankingImage = value
    }

    /**
     * @param value When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
     */
    @JvmName("wqvsfdpfbtatgsiq")
    public suspend fun state(`value`: Output<String>) {
        this.state = value
    }

    /**
     * @param value Blanking image to be used. See Avail Blanking Image for more details.
     */
    @JvmName("eiyfeqfdssqlgnor")
    public suspend
    fun availBlankingImage(`value`: ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.availBlankingImage = mapped
    }

    /**
     * @param argument Blanking image to be used. See Avail Blanking Image for more details.
     */
    @JvmName("ryeponxormfrncgf")
    public suspend
    fun availBlankingImage(argument: suspend ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsAvailBlankingAvailBlankingImageArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.availBlankingImage = mapped
    }

    /**
     * @param value When set to enabled, causes video, audio and captions to be blanked when insertion metadata is added.
     */
    @JvmName("cgyjmllofwpmtpmh")
    public suspend fun state(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): ChannelEncoderSettingsAvailBlankingArgs =
        ChannelEncoderSettingsAvailBlankingArgs(
            availBlankingImage = availBlankingImage,
            state = state,
        )
}
