@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.medialive.kotlin.inputs

import com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property aribDestinationSettings ARIB Destination Settings.
 * @property burnInDestinationSettings Burn In Destination Settings. See Burn In Destination Settings for more details.
 * @property dvbSubDestinationSettings DVB Sub Destination Settings. See DVB Sub Destination Settings for more details.
 * @property ebuTtDDestinationSettings EBU TT D Destination Settings. See EBU TT D Destination Settings for more details.
 * @property embeddedDestinationSettings Embedded Destination Settings.
 * @property embeddedPlusScte20DestinationSettings Embedded Plus SCTE20 Destination Settings.
 * @property rtmpCaptionInfoDestinationSettings RTMP Caption Info Destination Settings.
 * @property scte20PlusEmbeddedDestinationSettings SCTE20 Plus Embedded Destination Settings.
 * @property scte27DestinationSettings SCTE27 Destination Settings.
 * @property smpteTtDestinationSettings SMPTE TT Destination Settings.
 * @property teletextDestinationSettings Teletext Destination Settings.
 * @property ttmlDestinationSettings TTML Destination Settings. See TTML Destination Settings for more details.
 * @property webvttDestinationSettings WebVTT Destination Settings. See WebVTT Destination Settings for more details.
 */
public data class ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs(
    public val aribDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettingsArgs>? =
        null,
    public val burnInDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs>? =
        null,
    public val dvbSubDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettingsArgs>? =
        null,
    public val ebuTtDDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettingsArgs>? =
        null,
    public val embeddedDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettingsArgs>? =
        null,
    public val embeddedPlusScte20DestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettingsArgs>? =
        null,
    public val rtmpCaptionInfoDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettingsArgs>? =
        null,
    public val scte20PlusEmbeddedDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettingsArgs>? =
        null,
    public val scte27DestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettingsArgs>? =
        null,
    public val smpteTtDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettingsArgs>? =
        null,
    public val teletextDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettingsArgs>? =
        null,
    public val ttmlDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettingsArgs>? =
        null,
    public val webvttDestinationSettings:
    Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs>? =
        null,
) :
    ConvertibleToJava<com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs> {
    override fun toJava():
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs =
        com.pulumi.aws.medialive.inputs.ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs.builder()
            .aribDestinationSettings(
                aribDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .burnInDestinationSettings(
                burnInDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dvbSubDestinationSettings(
                dvbSubDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ebuTtDDestinationSettings(
                ebuTtDDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .embeddedDestinationSettings(
                embeddedDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .embeddedPlusScte20DestinationSettings(
                embeddedPlusScte20DestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .rtmpCaptionInfoDestinationSettings(
                rtmpCaptionInfoDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .scte20PlusEmbeddedDestinationSettings(
                scte20PlusEmbeddedDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .scte27DestinationSettings(
                scte27DestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .smpteTtDestinationSettings(
                smpteTtDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .teletextDestinationSettings(
                teletextDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ttmlDestinationSettings(
                ttmlDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .webvttDestinationSettings(
                webvttDestinationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs].
 */
@PulumiTagMarker
public class ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgsBuilder internal
constructor() {
    private var aribDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettingsArgs>? =
        null

    private var burnInDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs>? =
        null

    private var dvbSubDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettingsArgs>? =
        null

    private var ebuTtDDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettingsArgs>? =
        null

    private var embeddedDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettingsArgs>? =
        null

    private var embeddedPlusScte20DestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettingsArgs>? =
        null

    private var rtmpCaptionInfoDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettingsArgs>? =
        null

    private var scte20PlusEmbeddedDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettingsArgs>? =
        null

    private var scte27DestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettingsArgs>? =
        null

    private var smpteTtDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettingsArgs>? =
        null

    private var teletextDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettingsArgs>? =
        null

    private var ttmlDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettingsArgs>? =
        null

    private var webvttDestinationSettings:
        Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs>? =
        null

    /**
     * @param value ARIB Destination Settings.
     */
    @JvmName("flraijknhkgijktu")
    public suspend
    fun aribDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettingsArgs>) {
        this.aribDestinationSettings = value
    }

    /**
     * @param value Burn In Destination Settings. See Burn In Destination Settings for more details.
     */
    @JvmName("gyifefedvntndojr")
    public suspend
    fun burnInDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs>) {
        this.burnInDestinationSettings = value
    }

    /**
     * @param value DVB Sub Destination Settings. See DVB Sub Destination Settings for more details.
     */
    @JvmName("ybpwksiqnaspucro")
    public suspend
    fun dvbSubDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettingsArgs>) {
        this.dvbSubDestinationSettings = value
    }

    /**
     * @param value EBU TT D Destination Settings. See EBU TT D Destination Settings for more details.
     */
    @JvmName("ddxxlnekdcxghmdb")
    public suspend
    fun ebuTtDDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettingsArgs>) {
        this.ebuTtDDestinationSettings = value
    }

    /**
     * @param value Embedded Destination Settings.
     */
    @JvmName("tphffiacpoqcbhgu")
    public suspend
    fun embeddedDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettingsArgs>) {
        this.embeddedDestinationSettings = value
    }

    /**
     * @param value Embedded Plus SCTE20 Destination Settings.
     */
    @JvmName("nkdunhygbiqcgido")
    public suspend
    fun embeddedPlusScte20DestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettingsArgs>) {
        this.embeddedPlusScte20DestinationSettings = value
    }

    /**
     * @param value RTMP Caption Info Destination Settings.
     */
    @JvmName("vskiqwwnashcndto")
    public suspend
    fun rtmpCaptionInfoDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettingsArgs>) {
        this.rtmpCaptionInfoDestinationSettings = value
    }

    /**
     * @param value SCTE20 Plus Embedded Destination Settings.
     */
    @JvmName("cfiugtyflwgkaexu")
    public suspend
    fun scte20PlusEmbeddedDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettingsArgs>) {
        this.scte20PlusEmbeddedDestinationSettings = value
    }

    /**
     * @param value SCTE27 Destination Settings.
     */
    @JvmName("ggpbtupwqnugsifs")
    public suspend
    fun scte27DestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettingsArgs>) {
        this.scte27DestinationSettings = value
    }

    /**
     * @param value SMPTE TT Destination Settings.
     */
    @JvmName("ooqcicaoxbpmsmpd")
    public suspend
    fun smpteTtDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettingsArgs>) {
        this.smpteTtDestinationSettings = value
    }

    /**
     * @param value Teletext Destination Settings.
     */
    @JvmName("lkonyiterhxycjhc")
    public suspend
    fun teletextDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettingsArgs>) {
        this.teletextDestinationSettings = value
    }

    /**
     * @param value TTML Destination Settings. See TTML Destination Settings for more details.
     */
    @JvmName("rtknotaslxcvxeed")
    public suspend
    fun ttmlDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettingsArgs>) {
        this.ttmlDestinationSettings = value
    }

    /**
     * @param value WebVTT Destination Settings. See WebVTT Destination Settings for more details.
     */
    @JvmName("gbuhxnrunnleuqin")
    public suspend
    fun webvttDestinationSettings(`value`: Output<ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs>) {
        this.webvttDestinationSettings = value
    }

    /**
     * @param value ARIB Destination Settings.
     */
    @JvmName("ndgvlmeuhmxalsxm")
    public suspend
    fun aribDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.aribDestinationSettings = mapped
    }

    /**
     * @param argument ARIB Destination Settings.
     */
    @JvmName("oxgaubexshxbacwp")
    public suspend
    fun aribDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsAribDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.aribDestinationSettings = mapped
    }

    /**
     * @param value Burn In Destination Settings. See Burn In Destination Settings for more details.
     */
    @JvmName("owiiuxkbagftywwh")
    public suspend
    fun burnInDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.burnInDestinationSettings = mapped
    }

    /**
     * @param argument Burn In Destination Settings. See Burn In Destination Settings for more details.
     */
    @JvmName("xmbhkrmwsvcrgoyn")
    public suspend
    fun burnInDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsBurnInDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.burnInDestinationSettings = mapped
    }

    /**
     * @param value DVB Sub Destination Settings. See DVB Sub Destination Settings for more details.
     */
    @JvmName("vgguntscdeggemyy")
    public suspend
    fun dvbSubDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dvbSubDestinationSettings = mapped
    }

    /**
     * @param argument DVB Sub Destination Settings. See DVB Sub Destination Settings for more details.
     */
    @JvmName("iiyukjiysqafstwc")
    public suspend
    fun dvbSubDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsDvbSubDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.dvbSubDestinationSettings = mapped
    }

    /**
     * @param value EBU TT D Destination Settings. See EBU TT D Destination Settings for more details.
     */
    @JvmName("joeffwnjposkorbo")
    public suspend
    fun ebuTtDDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ebuTtDDestinationSettings = mapped
    }

    /**
     * @param argument EBU TT D Destination Settings. See EBU TT D Destination Settings for more details.
     */
    @JvmName("twlftkslhinyiuog")
    public suspend
    fun ebuTtDDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEbuTtDDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ebuTtDDestinationSettings = mapped
    }

    /**
     * @param value Embedded Destination Settings.
     */
    @JvmName("ufiorlwjwovkdlck")
    public suspend
    fun embeddedDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.embeddedDestinationSettings = mapped
    }

    /**
     * @param argument Embedded Destination Settings.
     */
    @JvmName("qptcuhkspcjfoohh")
    public suspend
    fun embeddedDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.embeddedDestinationSettings = mapped
    }

    /**
     * @param value Embedded Plus SCTE20 Destination Settings.
     */
    @JvmName("mttrbcbhskwrpbdt")
    public suspend
    fun embeddedPlusScte20DestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.embeddedPlusScte20DestinationSettings = mapped
    }

    /**
     * @param argument Embedded Plus SCTE20 Destination Settings.
     */
    @JvmName("mbgjgyhkdmlxsgbu")
    public suspend
    fun embeddedPlusScte20DestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsEmbeddedPlusScte20DestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.embeddedPlusScte20DestinationSettings = mapped
    }

    /**
     * @param value RTMP Caption Info Destination Settings.
     */
    @JvmName("lrkhgwifflfyruwu")
    public suspend
    fun rtmpCaptionInfoDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.rtmpCaptionInfoDestinationSettings = mapped
    }

    /**
     * @param argument RTMP Caption Info Destination Settings.
     */
    @JvmName("jkemjgdpxluhlwle")
    public suspend
    fun rtmpCaptionInfoDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsRtmpCaptionInfoDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.rtmpCaptionInfoDestinationSettings = mapped
    }

    /**
     * @param value SCTE20 Plus Embedded Destination Settings.
     */
    @JvmName("qoijjdikxbdireur")
    public suspend
    fun scte20PlusEmbeddedDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte20PlusEmbeddedDestinationSettings = mapped
    }

    /**
     * @param argument SCTE20 Plus Embedded Destination Settings.
     */
    @JvmName("iwiprnvwfarjbwgm")
    public suspend
    fun scte20PlusEmbeddedDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte20PlusEmbeddedDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scte20PlusEmbeddedDestinationSettings = mapped
    }

    /**
     * @param value SCTE27 Destination Settings.
     */
    @JvmName("snumomjycubloptv")
    public suspend
    fun scte27DestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.scte27DestinationSettings = mapped
    }

    /**
     * @param argument SCTE27 Destination Settings.
     */
    @JvmName("mxlfrufgbpcyxcih")
    public suspend
    fun scte27DestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsScte27DestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.scte27DestinationSettings = mapped
    }

    /**
     * @param value SMPTE TT Destination Settings.
     */
    @JvmName("yphmhpjgaccyjqbv")
    public suspend
    fun smpteTtDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.smpteTtDestinationSettings = mapped
    }

    /**
     * @param argument SMPTE TT Destination Settings.
     */
    @JvmName("btovqjtmyouoaucp")
    public suspend
    fun smpteTtDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsSmpteTtDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.smpteTtDestinationSettings = mapped
    }

    /**
     * @param value Teletext Destination Settings.
     */
    @JvmName("phpvijmavaqimfqj")
    public suspend
    fun teletextDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.teletextDestinationSettings = mapped
    }

    /**
     * @param argument Teletext Destination Settings.
     */
    @JvmName("vgwmrpufiwrjgslu")
    public suspend
    fun teletextDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTeletextDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.teletextDestinationSettings = mapped
    }

    /**
     * @param value TTML Destination Settings. See TTML Destination Settings for more details.
     */
    @JvmName("agiwyjakafmvkqfk")
    public suspend
    fun ttmlDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ttmlDestinationSettings = mapped
    }

    /**
     * @param argument TTML Destination Settings. See TTML Destination Settings for more details.
     */
    @JvmName("pwkeollhdnwlrvjg")
    public suspend
    fun ttmlDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsTtmlDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.ttmlDestinationSettings = mapped
    }

    /**
     * @param value WebVTT Destination Settings. See WebVTT Destination Settings for more details.
     */
    @JvmName("pktlqsgyehpjdbxw")
    public suspend
    fun webvttDestinationSettings(`value`: ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webvttDestinationSettings = mapped
    }

    /**
     * @param argument WebVTT Destination Settings. See WebVTT Destination Settings for more details.
     */
    @JvmName("mkvwghssespgnkub")
    public suspend
    fun webvttDestinationSettings(argument: suspend ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped =
            ChannelEncoderSettingsCaptionDescriptionDestinationSettingsWebvttDestinationSettingsArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.webvttDestinationSettings = mapped
    }

    internal fun build(): ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs =
        ChannelEncoderSettingsCaptionDescriptionDestinationSettingsArgs(
            aribDestinationSettings = aribDestinationSettings,
            burnInDestinationSettings = burnInDestinationSettings,
            dvbSubDestinationSettings = dvbSubDestinationSettings,
            ebuTtDDestinationSettings = ebuTtDDestinationSettings,
            embeddedDestinationSettings = embeddedDestinationSettings,
            embeddedPlusScte20DestinationSettings = embeddedPlusScte20DestinationSettings,
            rtmpCaptionInfoDestinationSettings = rtmpCaptionInfoDestinationSettings,
            scte20PlusEmbeddedDestinationSettings = scte20PlusEmbeddedDestinationSettings,
            scte27DestinationSettings = scte27DestinationSettings,
            smpteTtDestinationSettings = smpteTtDestinationSettings,
            teletextDestinationSettings = teletextDestinationSettings,
            ttmlDestinationSettings = ttmlDestinationSettings,
            webvttDestinationSettings = webvttDestinationSettings,
        )
}
